/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);
    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<Object> handleException(Exception ex) {
        if (log.isDebugEnabled()) {
            log.debug("catch error = ", (Throwable)ex);
        }
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        HttpStatus status = HttpStatus.OK;
        if (ex instanceof AdxException) {
            AdxErrEnum adxErrEnum;
            AdxException adxException = (AdxException)ex;
            HttpStatus resolve = HttpStatus.resolve((int)adxException.getCode());
            if (Objects.nonNull(resolve)) {
                status = resolve;
            }
            if (Objects.nonNull(adxErrEnum = adxException.getAdxErrEnum())) {
                objectNode.put("result", adxErrEnum.getResult());
                objectNode.put("msg", adxException.getMessage());
            }
        }
        return ResponseEntity.status((HttpStatus)status).body((Object)objectNode);
    }
}

