/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter;

import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginConfigBidModelAdapter
implements BidModelAdapter,
PluginConfigAware {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigBidModelAdapter.class);
    private PluginConfig pluginConfig;

    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    protected String getMediaId() {
        String mediaId = this.pluginConfig.getProperties().getProperty("id");
        if (NumberUtils.isNumber((String)mediaId)) {
            return mediaId;
        }
        throw new AdxException(AdxErrEnum.PLUGIN_ERR);
    }

    protected Integer getEncModel() {
        String model = this.pluginConfig.getProperties().getProperty("encm");
        if (NumberUtils.isNumber((String)model)) {
            return Integer.valueOf(model);
        }
        return null;
    }

    @Override
    public BidRequest convert(byte[] bytes) {
        BidRequest bidRequest = (BidRequest)JsonHelper.convert((byte[])bytes, BidRequest.class);
        bidRequest.setMediaId(this.getMediaId());
        bidRequest.setEncModel(this.getEncModel());
        return bidRequest;
    }

    @Override
    public byte[] convert(BidResponse e, BidRequest bidRequest) {
        return JsonHelper.convert2bytes((Object)e);
    }
}

