/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.entity;

import com.bxm.warcar.utils.crypto.Base64UrlSafeStringAesCipher;
import com.bxm.warcar.utils.crypto.HexAesCipher;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiskControlDotParam {
    private static final String SPLIT = "|";
    public static final RiskControlDotParam EMPTY = new RiskControlDotParam();
    private final String text;
    private String assetType;
    private String appid;
    private String appName;
    private String appVer;
    private String appBundle;
    private String appCat;
    private String ip;
    private String deviceType;
    private String brand;
    private String os;
    private String osv;
    private String userId;
    private String keywords;
    private String city;

    private RiskControlDotParam() {
        this(null);
    }

    private RiskControlDotParam(String text) {
        this.text = text;
        String[] strings = Optional.ofNullable(StringUtils.splitPreserveAllTokens((String)text, (String)SPLIT)).orElse(new String[0]);
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                this.assetType = strings[i];
                continue;
            }
            if (i == 1) {
                this.appid = strings[i];
                continue;
            }
            if (i == 2) {
                this.appid = strings[i];
                continue;
            }
            if (i == 3) {
                this.appName = strings[i];
                continue;
            }
            if (i == 4) {
                this.appVer = strings[i];
                continue;
            }
            if (i == 5) {
                this.appBundle = strings[i];
                continue;
            }
            if (i == 6) {
                this.appCat = strings[i];
                continue;
            }
            if (i == 7) {
                this.ip = strings[i];
                continue;
            }
            if (i == 8) {
                this.deviceType = strings[i];
                continue;
            }
            if (i == 9) {
                this.brand = strings[i];
                continue;
            }
            if (i == 10) {
                this.os = strings[i];
                continue;
            }
            if (i == 11) {
                this.osv = strings[i];
                continue;
            }
            if (i == 12) {
                this.userId = strings[i];
                continue;
            }
            if (i == 13) {
                this.keywords = strings[i];
                continue;
            }
            if (i != 14) continue;
            this.city = strings[i];
        }
    }

    public String toString() {
        return this.text;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVer() {
        return this.appVer;
    }

    public String getAppBundle() {
        return this.appBundle;
    }

    public String getAppCat() {
        return this.appCat;
    }

    public String getIp() {
        return this.ip;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsv() {
        return this.osv;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getCity() {
        return this.city;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String assetType;
        private String appid;
        private String appName;
        private String appVer;
        private String appBundle;
        private String appCat;
        private String ip;
        private String deviceType;
        private String brand;
        private String os;
        private String osv;
        private String userId;
        private String keywords;
        private String city;

        public Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder appVer(String appVer) {
            this.appVer = appVer;
            return this;
        }

        public Builder appBundle(String appBundle) {
            this.appBundle = appBundle;
            return this;
        }

        public Builder appCat(String appCat) {
            this.appCat = appCat;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder osv(String osv) {
            this.osv = osv;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            return this;
        }

        public RiskControlDotParam build() {
            String s = this.append(this.assetType, this.appid, this.appName, this.appVer, this.appBundle, this.appCat, this.ip, this.deviceType, this.brand, this.os, this.osv, this.userId, this.keywords, this.city);
            return new RiskControlDotParam(s);
        }

        private String append(String ... strings) {
            StringBuilder s = new StringBuilder();
            String[] var3 = strings;
            int var4 = strings.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                String string = var3[var5];
                if (StringUtils.isBlank((String)string)) {
                    string = "";
                }
                s.append(string).append(RiskControlDotParam.SPLIT);
            }
            return StringUtils.removeEnd((String)s.toString(), (String)RiskControlDotParam.SPLIT);
        }
    }

    public static class Base64Cipher {
        private static final Logger log = LoggerFactory.getLogger(Base64Cipher.class);
        private static final String KEY = "bXm2021#world.bs";

        public static String encrypt(RiskControlDotParam param) {
            return Base64Cipher.encrypt(KEY, param);
        }

        public static String encrypt(String key, RiskControlDotParam param) {
            try {
                return Base64UrlSafeStringAesCipher.encrypt((String)key, (String)param.toString());
            }
            catch (Exception var3) {
                log.error("encrypt: ", (Throwable)var3);
                return null;
            }
        }

        public static RiskControlDotParam decrypt(String secretText) {
            return Base64Cipher.decrypt(KEY, secretText);
        }

        public static RiskControlDotParam decrypt(String key, String secretText) {
            try {
                String plaintext = Base64UrlSafeStringAesCipher.decrypt((String)key, (String)secretText);
                return new RiskControlDotParam(plaintext);
            }
            catch (Exception var3) {
                log.error("decrypt: ", (Throwable)var3);
                return EMPTY;
            }
        }
    }

    public static class HexCipher {
        private static final Logger log = LoggerFactory.getLogger(HexCipher.class);
        private static final String KEY = "bXm2021#world.hX";

        public static String encrypt(RiskControlDotParam param) {
            return HexCipher.encrypt(KEY, param);
        }

        public static String encrypt(String key, RiskControlDotParam param) {
            try {
                return HexAesCipher.encrypt((String)key, (String)param.toString());
            }
            catch (Exception var3) {
                log.error("encrypt: ", (Throwable)var3);
                return null;
            }
        }

        public static RiskControlDotParam decrypt(String secretText) {
            return HexCipher.decrypt(KEY, secretText);
        }

        public static RiskControlDotParam decrypt(String key, String secretText) {
            try {
                String plaintext = HexAesCipher.decrypt((String)key, (String)secretText);
                return new RiskControlDotParam(plaintext);
            }
            catch (Exception var3) {
                log.error("decrypt: ", (Throwable)var3);
                return EMPTY;
            }
        }
    }
}

