/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer;

import com.bxm.adx.common.buy.Buyer;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ClassUtils;

@Configuration
public class BuyerMeter
implements MeterBinder,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(BuyerMeter.class);
    private final Map<String, Timer> requestTimer = Maps.newHashMap();
    private final Map<String, Counter> requestCounter = Maps.newHashMap();
    private final Map<String, Counter> paddedCounter = Maps.newHashMap();
    private final Map<String, Counter> connectExceptionCounter = Maps.newHashMap();
    private final Map<String, Counter> readExceptionCounter = Maps.newHashMap();
    private MeterRegistry registry;

    public void recordRequest(Object bean, long start) {
        String key = this.getKey(bean);
        Timer timer = this.requestTimer.get(key);
        if (Objects.nonNull(timer)) {
            timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public void increaseRequest(Object bean) {
        String key = this.getKey(bean);
        Counter counter = this.requestCounter.get(key);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void increasePadding(Object bean) {
        String key = this.getKey(bean);
        Counter counter = this.paddedCounter.get(key);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void increaseConnectException(Object bean) {
        String key = this.getKey(bean);
        Counter counter = this.connectExceptionCounter.get(key);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void increaseReadException(Object bean) {
        String key = this.getKey(bean);
        Counter counter = this.readExceptionCounter.get(key);
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Map beans = applicationContext.getBeansOfType(Buyer.class);
        for (Map.Entry entry : beans.entrySet()) {
            Buyer buyer = (Buyer)entry.getValue();
            this.bindTo(buyer);
        }
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    private void bindTo(Buyer buyer) {
        String key = this.getKey(buyer);
        this.bindRequestTimer(key);
        this.bindRequestCounterMap(key);
        this.bindPaddedCounterMap(key);
        this.bindConnectExceptionCounterMap(key);
        this.bindReadExceptionCounterMap(key);
    }

    private void bindRequestCounterMap(String key) {
        if (this.requestCounter.containsKey(key)) {
            return;
        }
        Counter counter = Counter.builder((String)"adx.buyer.request").tags(new String[]{"name", key}).register(this.registry);
        this.requestCounter.put(key, counter);
    }

    private void bindPaddedCounterMap(String key) {
        if (this.paddedCounter.containsKey(key)) {
            return;
        }
        Counter counter = Counter.builder((String)"adx.buyer.padding").tags(new String[]{"name", key}).register(this.registry);
        this.paddedCounter.put(key, counter);
    }

    private void bindConnectExceptionCounterMap(String key) {
        if (this.connectExceptionCounter.containsKey(key)) {
            return;
        }
        Counter counter = Counter.builder((String)"adx.buyer.connect_exception").tags(new String[]{"name", key}).register(this.registry);
        this.connectExceptionCounter.put(key, counter);
    }

    private void bindReadExceptionCounterMap(String key) {
        if (this.readExceptionCounter.containsKey(key)) {
            return;
        }
        Counter counter = Counter.builder((String)"adx.buyer.read_exception").tags(new String[]{"name", key}).register(this.registry);
        this.readExceptionCounter.put(key, counter);
    }

    private void bindRequestTimer(String key) {
        if (this.requestTimer.containsKey(key)) {
            return;
        }
        Timer timer = Timer.builder((String)"adx.buyer").tags(new String[]{"name", key}).register(this.registry);
        this.requestTimer.put(key, timer);
    }

    private String getKey(Object bean) {
        return ClassUtils.getUserClass((Object)bean).getName();
    }
}

