/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.init.BidRequestInitializer;
import com.bxm.adx.common.sell.init.InitializerParam;
import com.bxm.adx.common.sell.position.Position;
import java.util.Objects;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class RequestInitializer
implements BidRequestInitializer {
    @Override
    public void accept(BidRequest bidRequest, InitializerParam param) {
        if (StringUtils.isEmpty((Object)bidRequest.getId())) {
            bidRequest.setId(RandomStringUtils.randomAlphabetic((int)10));
        }
        if (Objects.isNull(bidRequest.getAt())) {
            bidRequest.setAt(1);
        }
        if (Objects.isNull(bidRequest.getTest())) {
            bidRequest.setTest(0);
        }
        if (Objects.isNull(bidRequest.getT_max())) {
            bidRequest.setT_max(100);
        }
        if (Objects.isNull(bidRequest.getVer())) {
            bidRequest.setVer("2.4");
        }
        Position position = param.getPosition();
        bidRequest.setCooperationType(position.getCooperationType());
        bidRequest.setBxmTagId(position.getPositionId());
        this.initBidRequestByDockingMethodType(bidRequest, position);
    }

    private void initBidRequestByDockingMethodType(BidRequest bidRequest, Position position) {
        Integer dockingMethodType = position.getDockingMethodType();
        bidRequest.setDockingMethodType(dockingMethodType);
        Long waitTime = position.getWaitTime();
        Long overTime = position.getOvertime();
        if (Objects.nonNull(dockingMethodType)) {
            if (Objects.isNull(waitTime)) {
                waitTime = 1 == dockingMethodType ? AdxConstants.API_WAIT_TIME : AdxConstants.SDK_WAIT_TIME;
            }
            if (Objects.isNull(overTime)) {
                overTime = 1 == dockingMethodType ? AdxConstants.API_OVER_TIME : AdxConstants.SDK_OVER_TIME;
            }
        } else {
            waitTime = 0L;
            overTime = 0L;
        }
        bidRequest.setWaitTime(waitTime);
        bidRequest.setOvertime(overTime);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

