/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherConfigCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@CachePush(value="DISPATCHERAB")
@Component
public class DispatcherAB
implements Pushable {
    private static final Logger log = LoggerFactory.getLogger(DispatcherAB.class);
    private final Fetcher fetcher;
    private final Updater updater;
    private final com.bxm.warcar.xcache.Fetcher fetcher2;
    private final PositionService positionService;
    private final DspService dspService;
    private final DataSyncProducer dataSyncProducer;
    private final DispatcherConfigCached dispatcherConfigCached;

    public DispatcherAB(Fetcher fetcher, Updater updater, com.bxm.warcar.xcache.Fetcher fetcher2, PositionService positionService, DspService dspService, DataSyncProducer dataSyncProducer, DispatcherConfigCached dispatcherConfigCached) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.fetcher2 = fetcher2;
        this.positionService = positionService;
        this.dspService = dspService;
        this.dataSyncProducer = dataSyncProducer;
        this.dispatcherConfigCached = dispatcherConfigCached;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        DispatcherAbCacheVO dispatcherAbCacheVO;
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            if (log.isInfoEnabled()) {
                log.info("DISPATCHERAB push err: POSITION_ID is null");
            }
            return;
        }
        String positionId = Objects.toString(o);
        if (log.isInfoEnabled()) {
            log.info("DISPATCHERAB push {} : {}", (Object)positionId, (Object)new String(data));
        }
        if ((dispatcherAbCacheVO = (DispatcherAbCacheVO)JsonHelper.convert((byte[])data, DispatcherAbCacheVO.class)) == null) {
            return;
        }
        String key = dispatcherAbCacheVO.getClass().getName() + "$" + dispatcherAbCacheVO.getPositionId();
        this.dataSyncProducer.post(key, (Object)dispatcherAbCacheVO);
        this.updater.remove(CacheKeys.Dispather.getKeyGenerator(positionId));
        this.updater.remove(CacheKeys.Dispather.getKeyGeneratorByConfig(positionId));
        Position position = this.positionService.getByPositionId(positionId);
        if (position != null && !StringUtils.isEmpty((Object)position.getAppPositionId())) {
            this.updater.remove(CacheKeys.Dispather.getKeyGeneratorByAppPosId(position.getAppPositionId()));
            this.updater.remove(CacheKeys.Dispather.getKeyGeneratorByConfigAndAppPosId(position.getAppPositionId()));
        }
        this.updater.remove(CacheKeys.Dispather.getKeyGeneratorByAll(positionId));
        this.updater.remove(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId));
        List configs = dispatcherAbCacheVO.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty((Collection)configs)) {
            return;
        }
        for (DispatcherConfigCacheVO c : configs) {
            Integer start = c.getStart();
            Integer end = c.getEnd();
            Long configId = c.getId();
            this.userBucketing(positionId, configId, start, end);
            List dspCacheVOS = c.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty((Collection)dspCacheVOS)) continue;
            this.updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByAll(positionId), configId.toString(), (Object)dspCacheVOS);
            for (DispatcherDspCacheVO dispatcher : dspCacheVOS) {
                Dsp dsp;
                String dspId = Objects.toString(dispatcher.getDspId());
                this.updater.hupdate(CacheKeys.Dispather.getKeyGenerator(positionId), dspId, (Object)dispatcher);
                this.updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByConfig(positionId), configId + "-" + dspId, (Object)dispatcher);
                if (position == null || StringUtils.isEmpty((Object)position.getAppPositionId()) || Objects.isNull(dsp = this.dspService.get(Long.valueOf(dspId)))) continue;
                String dspCode = dsp.getDspCode();
                this.updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByAppPosId(position.getAppPositionId()), dspCode, (Object)dispatcher);
                this.updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByConfigAndAppPosId(position.getAppPositionId()), configId + "-" + dspCode, (Object)dispatcher);
            }
        }
    }

    private void userBucketing(String positionId, Long configId, Integer start, Integer end) {
        if (start == null || end == null) {
            start = 0;
            end = 99;
        }
        KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByBucketing(positionId);
        for (int i = start.intValue(); i <= end; ++i) {
            this.updater.hupdate(keyGenerator, i + "", (Object)configId);
        }
    }

    public Long getConfigId(String positionId, int bucket) {
        String configId = this.dispatcherConfigCached.getConfigId(positionId, bucket);
        if (StringUtils.isEmpty((Object)configId)) {
            KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByBucketing(positionId);
            return (Long)this.fetcher.hfetch(keyGenerator, bucket + "", Long.class);
        }
        return Long.valueOf(configId);
    }

    public Collection<DispatcherDspCacheVO> getDispatchersByConfigId(String positionId, Long configId) {
        KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByAll(positionId);
        Target target = new TargetFactory().keyGenerator(keyGenerator).cls(DispatcherDspCacheVO.class).field(configId.toString()).skipNativeCache(false).expireTimeInSecond(300).build();
        return this.fetcher2.hfetchToList(target);
    }
}

