/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherAB;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dispatcher.DispatcherParam;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigCaching;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.creative.replace.ReplaceCreativeDao;
import com.bxm.adx.common.rule.WhiteBlackSetRule;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.mccms.facade.model.Rule;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherDspPosPriceConfigVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class DispatcherServiceImpl
implements DispatcherService {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServiceImpl.class);
    private final DispatcherDao dispatcherDao;
    private final ReplaceCreativeDao replaceCreativeDao;
    private final DispatcherAB dispatcherAB;
    private final DispatcherConfigCached dispatcherConfigCached;
    private final DispatcherABConfigCaching dispatcherABConfigCaching;
    private final Fetcher fetcher;
    private final Updater updater;

    public DispatcherServiceImpl(DispatcherDao dispatcherDao, ReplaceCreativeDao replaceCreativeDao, DispatcherAB dispatcherAB, DispatcherConfigCached dispatcherConfigCached, DispatcherABConfigCaching dispatcherABConfigCaching, Fetcher fetcher, Updater updater) {
        this.dispatcherDao = dispatcherDao;
        this.replaceCreativeDao = replaceCreativeDao;
        this.dispatcherAB = dispatcherAB;
        this.dispatcherConfigCached = dispatcherConfigCached;
        this.dispatcherABConfigCaching = dispatcherABConfigCaching;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public Map<Integer, Collection<Dispatcher>> getPriority(Position position, DispatcherParam param) {
        Collection dispatchers = this.filterDispatcher(position, param);
        TreeMap dsps = Maps.newTreeMap();
        if (CollectionUtils.isEmpty(dispatchers)) {
            return dsps;
        }
        dispatchers = dispatchers.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getOpened() == 1).filter(dispatcherDspCacheVO -> this.limitedByPrice((DispatcherDspCacheVO)dispatcherDspCacheVO, param)).filter(dispatcherDspCacheVO -> this.limitedByAppPackageName((DispatcherDspCacheVO)dispatcherDspCacheVO, param)).filter(dispatcherDspCacheVO -> this.limitedByInstallAppList((DispatcherDspCacheVO)dispatcherDspCacheVO, param)).collect(Collectors.toList());
        for (DispatcherDspCacheVO dispatcher : dispatchers) {
            int priority = dispatcher.getPriority();
            Collection collection = MapHelper.get(dsps, Integer.valueOf(priority), new ArrayList());
            Dispatcher d = new Dispatcher();
            BeanUtils.copyProperties((Object)dispatcher, (Object)d);
            List creativeIds = dispatcher.getCreativeIdList();
            if (CollectionUtils.isNotEmpty((Collection)creativeIds)) {
                List<ReplaceCreative> creativeList = this.replaceCreativeDao.queryCreativeListByIds(creativeIds);
                d.setCreativeList(creativeList);
            }
            d.setDispatcherPriceConfig(this.getPriceConfigByTime(dispatcher.getDispatcherDspPosPriceConfigVOS()));
            collection.add(d);
        }
        return dsps;
    }

    @Override
    public Collection<Dispatcher> get(String positionId) {
        return this.dispatcherDao.get(positionId);
    }

    @Override
    public Dispatcher getByAppPosId(String appPosId, String dspCode) {
        return this.dispatcherDao.getByAppPosId(appPosId, dspCode);
    }

    @Override
    public Dispatcher get(String positionId, String dspId) {
        return this.dispatcherDao.get(positionId, dspId);
    }

    private Collection<DispatcherDspCacheVO> filterDispatcher(Position position, DispatcherParam dispatcherParam) {
        int userBucket;
        String configIdStr;
        String positionId = position.getPositionId();
        DispatcherABConfig dispatcherABConfig = (DispatcherABConfig)this.dispatcherABConfigCaching.get(positionId);
        if (Objects.isNull(dispatcherABConfig)) {
            return null;
        }
        Integer dockingMethodType = position.getDockingMethodType();
        String uid = AdxContextFactory.get().getUid();
        if (StringUtils.isEmpty((Object)uid)) {
            uid = RandomStringUtils.randomAlphabetic((int)13);
        }
        Long configId = StringUtils.isEmpty((Object)(configIdStr = this.dispatcherConfigCached.getConfigId(positionId, userBucket = AdxUtils.getBucket(uid)))) ? null : Long.valueOf(configIdStr);
        Collection<Object> dspCacheVOS = null;
        if (Objects.isNull(configId)) {
            if (log.isWarnEnabled()) {
                log.warn("position {} user bucket {} fail ", (Object)positionId, (Object)userBucket);
            }
            Collection<Dispatcher> ds = this.dispatcherDao.get(positionId);
            dspCacheVOS = new ArrayList();
            if (CollectionUtils.isEmpty(ds)) {
                throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
            }
            for (Dispatcher dispatcher : ds) {
                DispatcherDspCacheVO dspCacheVO = new DispatcherDspCacheVO();
                BeanUtils.copyProperties((Object)dispatcher, (Object)dspCacheVO);
                dspCacheVO.setOpened(dispatcher.getOpened());
                dspCacheVOS.add(dspCacheVO);
            }
        } else {
            AdxContextFactory.get().setConfigId(configId);
            if (Objects.nonNull(dockingMethodType) && dockingMethodType == 1) {
                return this.dispatcherDao.getDispatchersByConfigId(positionId, configId);
            }
            dspCacheVOS = this.fetcher.hfetchList(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, DispatcherDspCacheVO.class);
            if (CollectionUtils.isEmpty(dspCacheVOS)) {
                dspCacheVOS = this.dispatcherDao.getDispatchersByConfigId(positionId, configId);
            }
            dspCacheVOS = this.reorder(dspCacheVOS, uid, dispatcherParam);
            LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
            this.updater.hupdate(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId), uid, dspCacheVOS, (int)seconds);
        }
        return dspCacheVOS;
    }

    private int getPositionDspFreq(DispatcherDspCacheVO cacheVO, String uid) {
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(cacheVO, uid);
        Long freq = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(freq) ? 0 : freq.intValue();
    }

    private void resetPositionDspFreq(DispatcherDspCacheVO cacheVO, String uid) {
        KeyGenerator keyGenerator = this.getFreqKeyGenerator(cacheVO, uid);
        this.updater.update(keyGenerator, (Object)0);
    }

    private KeyGenerator getFreqKeyGenerator(DispatcherDspCacheVO cacheVO, String uid) {
        return AdxKeyGenerator.Counter.getPositionDspFrequency((String)cacheVO.getPositionId(), (String)cacheVO.getConfigId().toString(), (String)cacheVO.getDspId().toString(), (String)uid);
    }

    private Collection<DispatcherDspCacheVO> reorder(Collection<DispatcherDspCacheVO> ds, String uid, DispatcherParam dispatcherParam) {
        if (dispatcherParam.isSDKConcurrentModel()) {
            return ds;
        }
        ArrayList<DispatcherDspCacheVO> result = new ArrayList<DispatcherDspCacheVO>();
        List ps = ds.stream().map(DispatcherDspCacheVO::getPriority).sorted().distinct().collect(Collectors.toList());
        Integer max = (Integer)ps.get(ps.size() - 1);
        for (Integer p : ps) {
            List dspCacheVOS = ds.stream().filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getPriority() == p.intValue()).filter(dispatcherDspCacheVO -> dispatcherDspCacheVO.getOpened() == 1).collect(Collectors.toList());
            if (dspCacheVOS.size() == 1) {
                Integer used;
                DispatcherDspCacheVO dc = (DispatcherDspCacheVO)dspCacheVOS.iterator().next();
                Integer initFreq = dc.getFrequency();
                if (null != initFreq && (used = Integer.valueOf(this.getPositionDspFreq(dc, uid))) >= initFreq) {
                    if (dc.getPriority() != max.intValue()) {
                        max = max + 1;
                        dc.setPriority(max.intValue());
                    }
                    this.resetPositionDspFreq(dc, uid);
                }
                result.add(dc);
                continue;
            }
            result.addAll(dspCacheVOS);
        }
        return result;
    }

    private boolean limitedByPrice(DispatcherDspCacheVO dispatcher, DispatcherParam param) {
        if (param.isSDKConcurrentModel()) {
            BigDecimal price = dispatcher.getDspAvgPrice();
            if (price.compareTo(param.getMinPrice().movePointLeft(2)) == -1) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"< min");
                }
                return false;
            }
            if (price.compareTo(param.getMaxPrice().movePointLeft(2)) >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"> max");
                }
                return false;
            }
        }
        return true;
    }

    private boolean limitedByInstallAppList(DispatcherDspCacheVO dispatcher, DispatcherParam param) {
        List<String> installList = param.getInstallAppList();
        Rule rule = dispatcher.getInstalledAppDirect();
        if (Objects.isNull(rule)) {
            return true;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (CollectionUtils.isEmpty(installList)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-white-empty");
                }
                return false;
            }
            Collection result = CollectionUtils.intersection(installList, set);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-white-empty");
            }
            return false;
        }
        if (CollectionUtils.isEmpty(installList)) {
            return true;
        }
        Collection result = CollectionUtils.intersection(installList, set);
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"installApp-black");
            }
            return false;
        }
        return true;
    }

    private boolean limitedByAppPackageName(DispatcherDspCacheVO dispatcher, DispatcherParam param) {
        String packageName = param.getMediaAppPackageName();
        Rule rule = dispatcher.getMediaAppDirect();
        if (Objects.isNull(rule)) {
            return true;
        }
        WhiteBlackSetRule setRule = new WhiteBlackSetRule(rule);
        Set<String> set = setRule.getSet();
        if (setRule.isWhite()) {
            if (StringUtils.isEmpty((Object)packageName)) {
                if (log.isDebugEnabled()) {
                    log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-white-empty");
                }
                return false;
            }
            if (set.contains(packageName)) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-white");
            }
            return false;
        }
        if (StringUtils.isEmpty((Object)packageName)) {
            return true;
        }
        if (set.contains(packageName)) {
            if (log.isDebugEnabled()) {
                log.debug("rm dispatcher {} by : {}", (Object)dispatcher.getId(), (Object)"packageName-black");
            }
            return false;
        }
        return true;
    }

    private DispatcherPriceConfig getPriceConfigByTime(List<DispatcherDspPosPriceConfigVO> configs) {
        if (CollectionUtils.isEmpty(configs)) {
            return null;
        }
        int hour = LocalDateTime.now().get(ChronoField.HOUR_OF_DAY);
        for (DispatcherDspPosPriceConfigVO config : configs) {
            Integer start = config.getStartTime();
            Integer end = config.getEndTime();
            if (!Objects.nonNull(start) || !Objects.nonNull(end) || start > hour || hour >= end) continue;
            DispatcherPriceConfig dispatcherPriceConfig = new DispatcherPriceConfig();
            BeanUtils.copyProperties((Object)config, (Object)dispatcherPriceConfig);
            return dispatcherPriceConfig;
        }
        return DispatcherPriceConfig.builder().ltPriceDiscountFactor(BigDecimal.ONE).gtPriceDiscountFactor(BigDecimal.ONE).biddingCoefficient(BigDecimal.ONE).profitMargin(BigDecimal.ZERO).build();
    }
}

