/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.abtest.cached;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DispatcherCached
implements DispatcherABConfigChangeHandler {
    private final ConcurrentHashMap<String, Set<Dispatcher>> configDispatcherMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            String positionId = latest.getPositionId();
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) continue;
                this.configDispatcherMap.put(DispatcherCached.buildKey(positionId, dispatcherConfig.getId()), dispatchers.stream().collect(Collectors.toSet()));
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }
        String positionId = old.getPositionId();
        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            this.configDispatcherMap.remove(DispatcherCached.buildKey(positionId, dispatcherConfig.getId()));
        }
    }

    public Set<Dispatcher> getDispatchers(String positionId, String configId) {
        return this.configDispatcherMap.get(DispatcherCached.buildKey(positionId, configId));
    }

    private static String buildKey(String positionId, String configId) {
        return positionId + "-" + configId;
    }
}

