/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspCaching;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspDataSyncHandler
implements DataSyncHandler {
    private static final Logger log = LoggerFactory.getLogger(DspDataSyncHandler.class);
    private final DspCaching dspCaching;

    public DspDataSyncHandler(DspCaching dspCaching) {
        this.dspCaching = dspCaching;
    }

    @Override
    public Class<?> getClazz() {
        return Dsp.class;
    }

    @Override
    public Object set(String key, Object object) {
        if (!(object instanceof Dsp)) {
            log.warn("object {} not support", object);
            return object;
        }
        Dsp dsp = (Dsp)object;
        if (dsp.isForbidden()) {
            this.dspCaching.del(dsp.getDspCode());
        } else {
            this.dspCaching.set(dsp.getDspCode(), dsp);
        }
        return object;
    }
}

