/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.filter.AbstractDspFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DspMaxExposureLimiterFilter
extends AbstractDspFilter {
    private static final Logger log = LoggerFactory.getLogger(DspMaxExposureLimiterFilter.class);
    private final Fetcher fetcher;

    public DspMaxExposureLimiterFilter(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    protected List<Dispatcher> doFilter(MarketOrders marketOrders) {
        List<MarketRequest> requests = marketOrders.getRequests();
        if (CollectionUtils.isEmpty(requests)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        requests.forEach(position -> {
            Set<BuyerWrapper> buyerWrappers = position.getBuyers();
            if (CollectionUtils.isEmpty(buyerWrappers)) {
                return;
            }
            buyerWrappers.forEach(buyerWrapper -> {
                Dispatcher dispatcher = buyerWrapper.getDispatcher();
                if (Objects.isNull(dispatcher.getMaxExposure())) {
                    return;
                }
                if (this.getPositionDspExposure(dispatcher) >= dispatcher.getMaxExposure()) {
                    list.add(dispatcher);
                }
            });
        });
        return list;
    }

    private int getPositionDspExposure(Dispatcher dispatcher) {
        String dspId;
        String configId = dispatcher.getConfigId().toString();
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getPositionDspExposure((String)configId, (String)(dspId = dispatcher.getDspId().toString()));
        Long exposure = (Long)this.fetcher.fetch(keyGenerator, Long.class);
        return Objects.isNull(exposure) ? 0 : exposure.intValue();
    }

    @Override
    public int order() {
        return 5;
    }
}

