/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.DspThreadPoolProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.log.dsplog.DspLogRecord;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.CustomRejected;
import com.bxm.adx.common.market.exchange.ExchangeCacheCallable;
import com.bxm.adx.common.market.exchange.ExchangeCallable;
import com.bxm.adx.common.market.exchange.ExchangeParam;
import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuildFactory;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuildFactory;
import com.bxm.adx.common.market.filter.PriceLowerFilter;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.rebuild.request.RebuildRequestChain;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
public class RtbExchanger
implements Exchanger,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RtbExchanger.class);
    private final BuyerMeter buyerMeter;
    private final EventPark eventPark;
    private final BuyerResponseCache buyerResponseCache;
    private final PriceLowerFilter priceLowerFilter;
    private final DataLogDao dataLogDao;
    private final ThreadPoolExecutor executor;
    private final DspLogRecord dspLogRecord;
    private final RebuildRequestChain requestChain;
    private final AdxBidRequestBuildFactory factory;
    private final AdxBidResponseBuildFactory responseBuildFactory;

    public RtbExchanger(BuyerMeter buyerMeter, EventPark eventPark, BuyerResponseCache buyerResponseCache, PriceLowerFilter priceLowerFilter, DataLogDao dataLogDao, CustomRejected customRejected, AdxProperties adxProperties, DspLogRecord dspLogRecord, RebuildRequestChain requestChain, AdxBidRequestBuildFactory factory, AdxBidResponseBuildFactory responseBuildFactory) {
        this.buyerMeter = buyerMeter;
        this.eventPark = eventPark;
        this.buyerResponseCache = buyerResponseCache;
        this.priceLowerFilter = priceLowerFilter;
        this.dataLogDao = dataLogDao;
        this.dspLogRecord = dspLogRecord;
        this.requestChain = requestChain;
        this.factory = factory;
        this.responseBuildFactory = responseBuildFactory;
        DspThreadPoolProperties dspThreadPool = adxProperties.getDspThreadPool();
        this.executor = new ThreadPoolExecutor(dspThreadPool.getCoreCount(), dspThreadPool.getMaxCount(), dspThreadPool.getLiveTime().intValue(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(dspThreadPool.getQueueLength()), (ThreadFactory)new NamedThreadFactory("exchange"), customRejected);
    }

    @Override
    public List<Deal> bidding(BidRequest bidRequest, Collection<BuyerWrapper> buyers) {
        if (0 == buyers.size() || null == bidRequest) {
            return Lists.newArrayList();
        }
        ArrayList futures = Lists.newArrayList();
        CountDownLatch waitCountDown = new CountDownLatch(buyers.size());
        CountDownLatch overtimeCountDown = new CountDownLatch(1);
        for (BuyerWrapper buyer : buyers) {
            ExchangeParam exchangeParam = new ExchangeParam();
            exchangeParam.setDispatcher(buyer.getDispatcher());
            BidRequest adxBidRequest = this.factory.buildAdxBidRequest(bidRequest, RequestBuildAttribute.builder().buyerWrapper(buyer).build());
            futures.add(this.executor.submit(new ExchangeCallable(buyer, bidRequest, adxBidRequest, this.buyerMeter, exchangeParam, this.eventPark, this.buyerResponseCache, waitCountDown, overtimeCountDown, AdxContextFactory.get().getBidConfig(), this.dataLogDao, this.dspLogRecord, this.requestChain, this.responseBuildFactory)));
            Dsp dsp = buyer.getBuyer().getDsp();
            Long cacheTime = dsp.getCacheTime();
            if (Objects.isNull(cacheTime) || cacheTime.intValue() == 0) continue;
            futures.add(this.executor.submit(new ExchangeCacheCallable(bidRequest, buyer, this.buyerResponseCache)));
        }
        List<Deal> deals = this.waitDealFilter(waitCountDown, bidRequest.getWaitTime(), futures);
        if (!CollectionUtils.isEmpty(deals)) {
            return deals;
        }
        if (futures.size() == 0) {
            return Collections.emptyList();
        }
        deals = this.waitDealFilter(overtimeCountDown, bidRequest.getOvertime() - bidRequest.getWaitTime(), futures);
        if (!CollectionUtils.isEmpty(deals)) {
            return deals;
        }
        return Collections.emptyList();
    }

    private List<Deal> waitDealFilter(CountDownLatch waitCountDown, Long waitTime, List<Future<Deal>> dealList) {
        try {
            waitCountDown.await(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("countDown err", (Throwable)e);
            return null;
        }
        ArrayList deals = Lists.newArrayList();
        Iterator<Future<Deal>> iterator = dealList.iterator();
        while (iterator.hasNext()) {
            Future<Deal> future = iterator.next();
            try {
                if (!future.isDone()) continue;
                Deal response = future.get();
                if (null != response) {
                    deals.add(response);
                }
                iterator.remove();
            }
            catch (InterruptedException | ExecutionException e) {
                future.cancel(true);
                log.error("execute: ", (Throwable)e);
            }
        }
        this.priceLowerFilter.filter(deals);
        return CollectionUtils.isEmpty((Collection)deals) ? Lists.newArrayList() : deals;
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

