/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NoneDspAvgPriceOffer
implements Offer {
    @Override
    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        HashMap<Bid, OfferResult> offerResultMap = new HashMap<Bid, OfferResult>(bids.size());
        for (Bid bid : bids) {
            BigDecimal offer = this.getPriceByConfig(request, dispatcher, bid.getPrice());
            offerResultMap.put(bid, OfferResult.builder().offer(offer).chargeType(1).build());
        }
        return offerResultMap;
    }

    @Override
    public OfferType offerType() {
        return OfferType.NONE_Dsp_Avg_Price;
    }

    private BigDecimal getPriceByConfig(BidRequest bidRequest, Dispatcher dispatcher, BigDecimal dspOffer) {
        BigDecimal maxBidFloor;
        DispatcherPriceConfig config = dispatcher.getDispatcherPriceConfig();
        if (Objects.isNull(config)) {
            return dspOffer;
        }
        BigDecimal newDspOffer = NoneDspAvgPriceOffer.getDspPriceByDispatcher(dspOffer, dispatcher);
        BigDecimal newPrice = newDspOffer.multiply(new BigDecimal(100.0).subtract(config.getProfitMargin())).multiply(config.getBiddingCoefficient()).movePointLeft(2);
        if (newPrice.compareTo(maxBidFloor = this.maxBidFloor(bidRequest, dispatcher)) >= 0) {
            return newPrice.setScale(0, RoundingMode.HALF_UP);
        }
        BigDecimal explorePrice = maxBidFloor.add(BigDecimal.ONE);
        if (newDspOffer.compareTo(explorePrice) >= 0) {
            return explorePrice.setScale(0, RoundingMode.HALF_UP);
        }
        return null;
    }

    private BigDecimal maxBidFloor(BidRequest bidRequest, Dispatcher dispatcher) {
        BigDecimal dispatcherBidFloor = Optional.ofNullable(dispatcher.getDspBasePrice()).orElse(BigDecimal.ZERO).movePointRight(2);
        BigDecimal bidFloor = bidRequest.getImps().iterator().next().getBid_floor();
        int result = bidFloor.compareTo(dispatcherBidFloor);
        switch (result) {
            case -1: {
                return dispatcherBidFloor;
            }
        }
        return bidFloor;
    }

    private static BigDecimal getDspPriceByDispatcher(BigDecimal dspOffer, Dispatcher dispatcher) {
        DispatcherPriceConfig config = dispatcher.getDispatcherPriceConfig();
        if (Objects.isNull(config)) {
            return dspOffer;
        }
        BigDecimal priceSplit = config.getPriceSplit();
        BigDecimal lt = config.getLtPriceDiscountFactor();
        BigDecimal gt = config.getGtPriceDiscountFactor();
        if (Objects.isNull(priceSplit)) {
            lt = Optional.ofNullable(lt).orElse(BigDecimal.ONE);
            return dspOffer.multiply(lt);
        }
        int compare = dspOffer.compareTo(priceSplit = priceSplit.movePointRight(2));
        if (compare <= 0) {
            return dspOffer.multiply(lt);
        }
        BigDecimal ltPrice = priceSplit.multiply(lt);
        BigDecimal gtPrice = dspOffer.subtract(priceSplit).multiply(gt);
        return ltPrice.add(gtPrice);
    }
}

