/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.offer.Offer;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferResult;
import com.bxm.adx.common.market.exchange.rebuild.offer.OfferType;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OfferFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private Map<OfferType, Offer> offerMap = new HashMap<OfferType, Offer>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Collection offerList = event.getApplicationContext().getBeansOfType(Offer.class).values();
        for (Offer offer : offerList) {
            this.offerMap.put(offer.offerType(), offer);
        }
    }

    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        OfferType offerType = this.getOfferType(request, dispatcher);
        Offer offer = this.offerMap.get((Object)offerType);
        HashMap<Bid, OfferResult> offerResultMap = null;
        if (Objects.isNull(offer)) {
            offerResultMap = new HashMap<Bid, OfferResult>(bids.size());
            for (Bid bid : bids) {
                offerResultMap.put(bid, OfferResult.builder().offer(bid.getPrice()).chargeType(1).build());
            }
            return offerResultMap;
        }
        return offer.offer(bids, request, dispatcher);
    }

    private OfferType getOfferType(BidRequest request, Dispatcher dispatcher) {
        BigDecimal avg = dispatcher.getDspAvgPrice();
        if (Objects.isNull(avg)) {
            return OfferType.NONE_Dsp_Avg_Price;
        }
        return OfferType.Dsp_Avg_Price;
    }
}

