/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.math.BigDecimal;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BidBuilder
implements AdxBidResponseBuilder {
    public int getOrder() {
        return 2;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest bidRequest = attribute.getBidRequest();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                if (StringUtils.isEmpty((String)bid.getId())) {
                    bid.setId(RandomStringUtils.randomAlphabetic((int)8));
                }
                if (StringUtils.isEmpty((String)bid.getAdid())) {
                    bid.setAdid(RandomStringUtils.randomAlphanumeric((int)5));
                }
                bid.setCharge_type(1);
                bid.setDsp_price(new BigDecimal(bid.getPrice().toString()));
                bid.setDsp_appid(dispatcher.getDspAppid());
                bid.setImp_id(bidRequest.getImps().iterator().next().getId());
            }
        }
    }
}

