/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.Native;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NativeBuilder
implements AdxBidResponseBuilder {
    public int getOrder() {
        return 3;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        ReplaceCreative creative = this.randomCreative(dispatcher.getCreativeList());
        if (Objects.isNull(creative)) {
            return;
        }
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                Native an = bid.getA_native();
                if (!Objects.nonNull(creative) || !Objects.nonNull(an) || !CollectionUtils.isNotEmpty(an.getAssets())) continue;
                this.buildNative(an, creative);
                bid.setAdxCreateId(creative.getId().toString());
            }
        }
    }

    private ReplaceCreative randomCreative(List<ReplaceCreative> creatives) {
        if (CollectionUtils.isNotEmpty(creatives)) {
            int r = RandomUtils.nextInt((int)creatives.size());
            return creatives.get(r);
        }
        return null;
    }

    private void buildNative(Native an, ReplaceCreative creative) {
        List<Asset> needReplace = this.needReplace(creative);
        if (CollectionUtils.isEmpty(needReplace)) {
            return;
        }
        HashSet replacedTypes = Sets.newHashSet();
        ArrayList<Asset> newAsset = new ArrayList<Asset>();
        for (Asset asset2 : an.getAssets()) {
            Integer type = asset2.getType();
            if (Objects.isNull(type)) continue;
            Optional<Asset> replace = null;
            replace = type.equals(AdxConstants.AssetType.REWARDER_VIDEO.getType()) ? needReplace.stream().filter(a -> a.getType().equals(AdxConstants.AssetType.VIDEO.getType())).findFirst() : needReplace.stream().filter(a -> a.getType().equals(type)).findFirst();
            if (replace.isPresent()) {
                Asset replaceAsset = replace.get();
                replacedTypes.add(replaceAsset.getType());
                if (type.equals(AdxConstants.AssetType.VIDEO.getType()) || type.equals(AdxConstants.AssetType.REWARDER_VIDEO.getType())) {
                    Video oldVideo = asset2.getVideo();
                    Video newVideo = replaceAsset.getVideo();
                    if (Objects.nonNull(oldVideo)) {
                        newVideo.setV_monitor(oldVideo.getV_monitor());
                        if (Objects.nonNull(newVideo.getCover_url())) {
                            oldVideo.setCover_url(newVideo.getCover_url());
                        }
                        if (Objects.nonNull(newVideo.getW())) {
                            oldVideo.setW(newVideo.getW());
                        }
                        if (Objects.nonNull(newVideo.getH())) {
                            oldVideo.setH(newVideo.getH());
                        }
                        if (Objects.nonNull(newVideo.getDuration())) {
                            oldVideo.setDuration(newVideo.getDuration());
                        }
                        if (Objects.nonNull(newVideo.getMax_length())) {
                            oldVideo.setMax_length(newVideo.getMax_length());
                        }
                        if (Objects.nonNull(newVideo.getUrl())) {
                            oldVideo.setUrl(newVideo.getUrl());
                        }
                        if (Objects.nonNull(newVideo.getMime_types())) {
                            oldVideo.setMime_types(newVideo.getMime_types());
                        }
                    }
                    Asset newVideoAsset = Asset.builder().type(type).video(oldVideo).build();
                    newAsset.add(newVideoAsset);
                    continue;
                }
                Asset copyAsset = (Asset)JsonHelper.convert((String)JsonHelper.convert((Object)replaceAsset), Asset.class);
                newAsset.add(copyAsset);
                continue;
            }
            newAsset.add(asset2);
        }
        List needAdd = needReplace.stream().filter(asset -> !replacedTypes.contains(asset.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needAdd)) {
            newAsset.addAll(needAdd);
        }
        an.setAssets(newAsset);
    }

    private List<Asset> needReplace(ReplaceCreative creative) {
        Integer h;
        Integer w;
        String[] sizes;
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Integer type = creative.getType();
        String title = creative.getTitle();
        String content = creative.getContent();
        String img = creative.getImageUrl();
        String icon = creative.getIconUrl();
        String source = creative.getSource();
        if (StringUtils.isNotEmpty((String)title)) {
            Asset titleAsset = Asset.builder().type(AdxConstants.AssetType.TITLE.getType()).text(Text.builder().text(title).build()).build();
            assets.add(titleAsset);
        }
        if (StringUtils.isNotEmpty((String)content)) {
            Asset contentAsset = Asset.builder().type(AdxConstants.AssetType.CONTENT.getType()).text(Text.builder().text(content).build()).build();
            assets.add(contentAsset);
        }
        if (StringUtils.isNotEmpty((String)source)) {
            Asset brandNameAsset = Asset.builder().type(AdxConstants.AssetType.BRAND_NAME.getType()).text(Text.builder().text(source).build()).build();
            assets.add(brandNameAsset);
        }
        if (StringUtils.isNotEmpty((String)img)) {
            String imageSize = creative.getImageSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)imageSize)) {
                try {
                    sizes = imageSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type.equals(1)) {
                Asset imgAsset = Asset.builder().type(AdxConstants.AssetType.LARGE_IMG.getType()).img(Image.builder().h(h).w(w).url(img).build()).build();
                assets.add(imgAsset);
            }
        }
        if (StringUtils.isNotEmpty((String)icon)) {
            String iconSize = creative.getIconSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)iconSize)) {
                try {
                    sizes = iconSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception imgAsset) {
                    // empty catch block
                }
            }
            Asset iconAsset = Asset.builder().type(AdxConstants.AssetType.ICON.getType()).img(Image.builder().h(h).w(w).url(icon).build()).build();
            assets.add(iconAsset);
        }
        if (type.equals(2)) {
            String videoSize = creative.getVideoSize();
            sizes = null;
            w = null;
            h = null;
            if (StringUtils.isNotEmpty((String)videoSize)) {
                try {
                    sizes = videoSize.split("\\*");
                    w = Integer.valueOf(sizes[0]);
                    h = Integer.valueOf(sizes[1]);
                }
                catch (Exception iconAsset) {
                    // empty catch block
                }
            }
            Video video = Video.builder().w(w).h(h).duration(Objects.isNull(creative.getVideoTime()) ? null : Integer.valueOf(creative.getVideoTime() * 1000)).cover_url(creative.getImageUrl()).mime_types(creative.getVideoFormat()).url(creative.getVideoUrl()).max_length(Objects.nonNull(creative.getVideoKb()) ? Integer.valueOf(creative.getVideoKb().intValue()) : null).build();
            Asset videoAsset = Asset.builder().video(video).type(AdxConstants.AssetType.VIDEO.getType()).build();
            assets.add(videoAsset);
        }
        return assets;
    }
}

