/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer;

import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.utils.SafeMapHelper;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SellerMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(SellerMeter.class);
    private final ConcurrentHashMap<String, Counter> paddedCounter = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Counter> positionMissCounter = new ConcurrentHashMap();
    private MeterRegistry registry;

    public void bindTo(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }

    public void increaseByAdxException(AdxException e, String path) {
        AdxErrEnum errEnum = e.getAdxErrEnum();
        if (Objects.isNull(errEnum)) {
            return;
        }
        switch (errEnum) {
            case POSITION_NOT_FOUND: {
                this.increasePositionMiss(path);
            }
        }
    }

    public void increasePadding(final String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        Counter counter = (Counter)SafeMapHelper.get(this.paddedCounter, (Object)path, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<Counter>(){

            public Counter initializing() {
                return Counter.builder((String)"adx.requests.padding").tags(new String[]{"path", path}).register(SellerMeter.this.registry);
            }
        });
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }

    public void increasePositionMiss(final String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        Counter counter = (Counter)SafeMapHelper.get(this.positionMissCounter, (Object)path, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<Counter>(){

            public Counter initializing() {
                return Counter.builder((String)"adx.requests.miss").tags(new String[]{"path", path}).register(SellerMeter.this.registry);
            }
        });
        if (Objects.nonNull(counter)) {
            counter.increment();
        }
    }
}

