/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sdkconfig;

import com.bxm.adx.common.sdkconfig.SdkConfig;
import com.bxm.adx.common.sdkconfig.SdkConfigDao;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="POSITION_SDK_CONFIG")
public class SdkConfigDaoImpl
implements SdkConfigDao,
Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public SdkConfigDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public List<SdkConfig> getByPositionId(String positionId) {
        return this.fetcher.fetchList(this.getKeyGenerator(positionId), SdkConfig.class);
    }

    @Override
    public Map<String, Integer> getByPositionIdDateChannelViewData(String positionId, String dmy, String devNo) {
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getSdk((String)positionId, (String)dmy, (String)devNo);
        return this.fetcher.hfetchall(keyGenerator, Integer.class);
    }

    @Override
    public void deletePositionIdDateChannelViewData(String positionId, String dmy, String devNo) {
        KeyGenerator keyGenerator = AdxKeyGenerator.Counter.getSdk((String)positionId, (String)dmy, (String)devNo);
        this.updater.remove(keyGenerator);
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get("positionId");
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        List sdkConfigList = (List)JsonHelper.convert((byte[])data, List.class);
        this.updater.remove(this.getKeyGenerator(positionId));
        if (CollectionUtils.isNotEmpty((Collection)sdkConfigList)) {
            this.updater.update(this.getKeyGenerator(positionId), (Object)sdkConfigList);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION_SDK_CONFIG", "POSITION_ID", value});
    }
}

