/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.builder;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BuildAttribute {
    private BidRequest sspRequest;
    private BidRequest adxRequest;
    private BidResponse adxResponse;
    private BidResponse dspResponse;
    private BigDecimal sspRequestPrice;
    private BigDecimal adxRequestPrice;
    private BigDecimal dspResponsePrice;
    private BigDecimal adxResponsePrice;
    private String configId;
    private String dspId;
    private String appId;
    private String tagId;
    private String dAppId;
    private String dTagId;
    private Integer mt;
    private String mediaId;

    public BuildAttribute(Integer mt) {
        this.mt = mt;
    }

    public BuildAttribute() {
    }

    public String getAppId() {
        if (Objects.isNull(this.sspRequest)) {
            return null;
        }
        App app = this.sspRequest.getApp();
        if (Objects.nonNull(app)) {
            return app.getId();
        }
        return null;
    }

    public String getTagId() {
        if (Objects.isNull(this.sspRequest)) {
            return null;
        }
        List<Impression> impressions = this.sspRequest.getImps();
        if (CollectionUtils.isNotEmpty(impressions)) {
            return impressions.iterator().next().getTag_id();
        }
        return null;
    }

    public String getdAppId() {
        String appid;
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        App app;
        if (Objects.nonNull(this.adxRequest) && Objects.nonNull(app = this.adxRequest.getApp())) {
            return app.getId();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid()) && !StringUtils.isEmpty((CharSequence)(appid = bids.iterator().next().getDsp_appid()))) {
            return appid;
        }
        return null;
    }

    public String getdTagId() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        List<Impression> impressions;
        if (StringUtils.isNotEmpty((CharSequence)this.dTagId)) {
            return this.dTagId;
        }
        if (Objects.nonNull(this.adxRequest) && CollectionUtils.isNotEmpty(impressions = this.adxRequest.getImps())) {
            return impressions.iterator().next().getTag_id();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getTag_id();
        }
        return null;
    }

    public BigDecimal getSspRequestPrice() {
        List<Impression> impressions;
        if (Objects.nonNull(this.sspRequest) && CollectionUtils.isNotEmpty(impressions = this.sspRequest.getImps())) {
            return impressions.iterator().next().getBid_floor();
        }
        return null;
    }

    public BigDecimal getAdxRequestPrice() {
        List<Impression> impressions;
        if (Objects.nonNull(this.adxRequest) && CollectionUtils.isNotEmpty(impressions = this.adxRequest.getImps())) {
            return impressions.iterator().next().getBid_floor();
        }
        return null;
    }

    public BigDecimal getDspResponsePrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.dspResponse) && CollectionUtils.isNotEmpty(seatBids = this.dspResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDsp_price();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDsp_price();
        }
        return null;
    }

    public BigDecimal getDspResponseWinPrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.dspResponse) && CollectionUtils.isNotEmpty(seatBids = this.dspResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDspWinPrice();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDspWinPrice();
        }
        return null;
    }

    private BigDecimal getAdxResponsePrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getPrice();
        }
        return null;
    }

    public String getPrice() {
        if (Objects.nonNull(this.mt)) {
            switch (this.mt) {
                case 1: {
                    return this.getSspRequestPrice().toString();
                }
                case 2: {
                    return this.getAdxRequestPrice().toString();
                }
                case 3: {
                    return this.getDspResponsePrice().toString();
                }
                case 4: {
                    return this.getAdxResponsePrice().toString();
                }
            }
            return null;
        }
        return null;
    }

    public String getMediaId() {
        if (Objects.nonNull(this.sspRequest)) {
            return this.sspRequest.getMediaId();
        }
        if (Objects.nonNull(this.adxRequest)) {
            return this.adxRequest.getMediaId();
        }
        return null;
    }

    public Integer getChargeType() {
        int bidModel = Optional.ofNullable(this.sspRequest.getBid_model()).orElse(1);
        switch (bidModel) {
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public BidRequest getSspRequest() {
        return this.sspRequest;
    }

    public BidRequest getAdxRequest() {
        return this.adxRequest;
    }

    public BidResponse getAdxResponse() {
        return this.adxResponse;
    }

    public BidResponse getDspResponse() {
        return this.dspResponse;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getDspId() {
        return this.dspId;
    }

    public Integer getMt() {
        return this.mt;
    }

    public BuildAttribute setSspRequest(BidRequest sspRequest) {
        this.sspRequest = sspRequest;
        return this;
    }

    public BuildAttribute setAdxRequest(BidRequest adxRequest) {
        this.adxRequest = adxRequest;
        return this;
    }

    public BuildAttribute setAdxResponse(BidResponse adxResponse) {
        this.adxResponse = adxResponse;
        return this;
    }

    public BuildAttribute setDspResponse(BidResponse dspResponse) {
        this.dspResponse = dspResponse;
        return this;
    }

    public BuildAttribute setSspRequestPrice(BigDecimal sspRequestPrice) {
        this.sspRequestPrice = sspRequestPrice;
        return this;
    }

    public BuildAttribute setAdxRequestPrice(BigDecimal adxRequestPrice) {
        this.adxRequestPrice = adxRequestPrice;
        return this;
    }

    public BuildAttribute setDspResponsePrice(BigDecimal dspResponsePrice) {
        this.dspResponsePrice = dspResponsePrice;
        return this;
    }

    public BuildAttribute setAdxResponsePrice(BigDecimal adxResponsePrice) {
        this.adxResponsePrice = adxResponsePrice;
        return this;
    }

    public BuildAttribute setConfigId(String configId) {
        this.configId = configId;
        return this;
    }

    public BuildAttribute setDspId(String dspId) {
        this.dspId = dspId;
        return this;
    }

    public BuildAttribute setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public BuildAttribute setTagId(String tagId) {
        this.tagId = tagId;
        return this;
    }

    public BuildAttribute setDAppId(String dAppId) {
        this.dAppId = dAppId;
        return this;
    }

    public BuildAttribute setDTagId(String dTagId) {
        this.dTagId = dTagId;
        return this;
    }

    public BuildAttribute setMt(Integer mt) {
        this.mt = mt;
        return this;
    }

    public BuildAttribute setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildAttribute)) {
            return false;
        }
        BuildAttribute other = (BuildAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mt = this.getMt();
        Integer other$mt = other.getMt();
        if (this$mt == null ? other$mt != null : !((Object)this$mt).equals(other$mt)) {
            return false;
        }
        BidRequest this$sspRequest = this.getSspRequest();
        BidRequest other$sspRequest = other.getSspRequest();
        if (this$sspRequest == null ? other$sspRequest != null : !((Object)this$sspRequest).equals(other$sspRequest)) {
            return false;
        }
        BidRequest this$adxRequest = this.getAdxRequest();
        BidRequest other$adxRequest = other.getAdxRequest();
        if (this$adxRequest == null ? other$adxRequest != null : !((Object)this$adxRequest).equals(other$adxRequest)) {
            return false;
        }
        BidResponse this$adxResponse = this.getAdxResponse();
        BidResponse other$adxResponse = other.getAdxResponse();
        if (this$adxResponse == null ? other$adxResponse != null : !((Object)this$adxResponse).equals(other$adxResponse)) {
            return false;
        }
        BidResponse this$dspResponse = this.getDspResponse();
        BidResponse other$dspResponse = other.getDspResponse();
        if (this$dspResponse == null ? other$dspResponse != null : !((Object)this$dspResponse).equals(other$dspResponse)) {
            return false;
        }
        BigDecimal this$sspRequestPrice = this.getSspRequestPrice();
        BigDecimal other$sspRequestPrice = other.getSspRequestPrice();
        if (this$sspRequestPrice == null ? other$sspRequestPrice != null : !((Object)this$sspRequestPrice).equals(other$sspRequestPrice)) {
            return false;
        }
        BigDecimal this$adxRequestPrice = this.getAdxRequestPrice();
        BigDecimal other$adxRequestPrice = other.getAdxRequestPrice();
        if (this$adxRequestPrice == null ? other$adxRequestPrice != null : !((Object)this$adxRequestPrice).equals(other$adxRequestPrice)) {
            return false;
        }
        BigDecimal this$dspResponsePrice = this.getDspResponsePrice();
        BigDecimal other$dspResponsePrice = other.getDspResponsePrice();
        if (this$dspResponsePrice == null ? other$dspResponsePrice != null : !((Object)this$dspResponsePrice).equals(other$dspResponsePrice)) {
            return false;
        }
        BigDecimal this$adxResponsePrice = this.getAdxResponsePrice();
        BigDecimal other$adxResponsePrice = other.getAdxResponsePrice();
        if (this$adxResponsePrice == null ? other$adxResponsePrice != null : !((Object)this$adxResponsePrice).equals(other$adxResponsePrice)) {
            return false;
        }
        String this$configId = this.getConfigId();
        String other$configId = other.getConfigId();
        if (this$configId == null ? other$configId != null : !this$configId.equals(other$configId)) {
            return false;
        }
        String this$dspId = this.getDspId();
        String other$dspId = other.getDspId();
        if (this$dspId == null ? other$dspId != null : !this$dspId.equals(other$dspId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$dAppId = this.getdAppId();
        String other$dAppId = other.getdAppId();
        if (this$dAppId == null ? other$dAppId != null : !this$dAppId.equals(other$dAppId)) {
            return false;
        }
        String this$dTagId = this.getdTagId();
        String other$dTagId = other.getdTagId();
        if (this$dTagId == null ? other$dTagId != null : !this$dTagId.equals(other$dTagId)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        return !(this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mt = this.getMt();
        result = result * 59 + ($mt == null ? 43 : ((Object)$mt).hashCode());
        BidRequest $sspRequest = this.getSspRequest();
        result = result * 59 + ($sspRequest == null ? 43 : ((Object)$sspRequest).hashCode());
        BidRequest $adxRequest = this.getAdxRequest();
        result = result * 59 + ($adxRequest == null ? 43 : ((Object)$adxRequest).hashCode());
        BidResponse $adxResponse = this.getAdxResponse();
        result = result * 59 + ($adxResponse == null ? 43 : ((Object)$adxResponse).hashCode());
        BidResponse $dspResponse = this.getDspResponse();
        result = result * 59 + ($dspResponse == null ? 43 : ((Object)$dspResponse).hashCode());
        BigDecimal $sspRequestPrice = this.getSspRequestPrice();
        result = result * 59 + ($sspRequestPrice == null ? 43 : ((Object)$sspRequestPrice).hashCode());
        BigDecimal $adxRequestPrice = this.getAdxRequestPrice();
        result = result * 59 + ($adxRequestPrice == null ? 43 : ((Object)$adxRequestPrice).hashCode());
        BigDecimal $dspResponsePrice = this.getDspResponsePrice();
        result = result * 59 + ($dspResponsePrice == null ? 43 : ((Object)$dspResponsePrice).hashCode());
        BigDecimal $adxResponsePrice = this.getAdxResponsePrice();
        result = result * 59 + ($adxResponsePrice == null ? 43 : ((Object)$adxResponsePrice).hashCode());
        String $configId = this.getConfigId();
        result = result * 59 + ($configId == null ? 43 : $configId.hashCode());
        String $dspId = this.getDspId();
        result = result * 59 + ($dspId == null ? 43 : $dspId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $dAppId = this.getdAppId();
        result = result * 59 + ($dAppId == null ? 43 : $dAppId.hashCode());
        String $dTagId = this.getdTagId();
        result = result * 59 + ($dTagId == null ? 43 : $dTagId.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        return result;
    }

    public String toString() {
        return "BuildAttribute(sspRequest=" + this.getSspRequest() + ", adxRequest=" + this.getAdxRequest() + ", adxResponse=" + this.getAdxResponse() + ", dspResponse=" + this.getDspResponse() + ", sspRequestPrice=" + this.getSspRequestPrice() + ", adxRequestPrice=" + this.getAdxRequestPrice() + ", dspResponsePrice=" + this.getDspResponsePrice() + ", adxResponsePrice=" + this.getAdxResponsePrice() + ", configId=" + this.getConfigId() + ", dspId=" + this.getDspId() + ", appId=" + this.getAppId() + ", tagId=" + this.getTagId() + ", dAppId=" + this.getdAppId() + ", dTagId=" + this.getdTagId() + ", mt=" + this.getMt() + ", mediaId=" + this.getMediaId() + ")";
    }
}

