/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.aspect;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.BidModelAdapter;
import com.bxm.adx.common.log.AdxDataLog;
import com.bxm.adx.common.log.AdxDataLogMonitor;
import com.bxm.adx.common.log.ByteLogger;
import com.bxm.adx.common.log.LogSourceEnum;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchCached;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategyFactory;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Base64;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAdapterRequestLogAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ModelAdapterRequestLogAdvice.class);
    private final ByteLogger byteLogger;
    private final PositionMappingStrategyFactory positionMappingStrategyFactory;
    private final BuriedSwitchCached buriedSwitchCached;
    private final AdxDataLogMonitor adxDataLogMonitor;

    public ModelAdapterRequestLogAdvice(ByteLogger byteLogger, PositionMappingStrategyFactory positionMappingStrategyFactory, BuriedSwitchCached buriedSwitchCached, AdxDataLogMonitor adxDataLogMonitor) {
        this.byteLogger = byteLogger;
        this.positionMappingStrategyFactory = positionMappingStrategyFactory;
        this.buriedSwitchCached = buriedSwitchCached;
        this.adxDataLogMonitor = adxDataLogMonitor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        if (arguments.length != 1 && !(arguments[0] instanceof byte[])) {
            return invocation.proceed();
        }
        byte[] data = (byte[])arguments[0];
        Object invocationThis = invocation.getThis();
        if (!(invocationThis instanceof BidModelAdapter)) {
            return invocation.proceed();
        }
        BidModelAdapter target = (BidModelAdapter)invocationThis;
        Object result = invocation.proceed();
        BidRequest bidRequest = (BidRequest)result;
        Position position = this.getPosition(bidRequest);
        if (this.checkBury(position)) {
            this.adxDataLogMonitor.requestMonitor(position.getPositionId());
            try {
                this.byteLogger.add(this.buildLog(target.getRequestFormat(), data, LogSourceEnum.MediaRequest, position, bidRequest));
                this.byteLogger.add(this.buildLog(AdxConstants.Format.Json, JsonHelper.convert2bytes((Object)result), LogSourceEnum.BxmRequest, position, bidRequest));
            }
            catch (Exception e) {
                log.warn("add: ", (Throwable)e);
            }
        }
        return result;
    }

    private AdxDataLog buildLog(AdxConstants.Format format, byte[] data, LogSourceEnum source, Position position, BidRequest bidRequest) {
        String request = null;
        switch (format) {
            case Protobuf: {
                request = Base64.getEncoder().encodeToString(data);
                break;
            }
            case Json: {
                request = new String(data);
            }
        }
        return AdxDataLog.builder().bidId(bidRequest.getId()).positionId(position.getPositionId()).format(format).request(request).source(source).build();
    }

    private boolean checkBury(Position position) {
        if (Objects.isNull(position)) {
            return false;
        }
        String positionId = position.getPositionId();
        return this.buriedSwitchCached.contains(positionId);
    }

    private Position getPosition(BidRequest bidRequest) {
        try {
            Impression impression = bidRequest.getImps().iterator().next();
            Position mediaPosition = this.positionMappingStrategyFactory.getPosition(bidRequest, impression);
            return mediaPosition;
        }
        catch (Exception e) {
            return null;
        }
    }
}

