/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterCondition;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilterEnum;
import com.bxm.adx.common.openlog.event.internal.AdxDispatcherFilter;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
public class DispatcherFilterFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(DispatcherFilterFactory.class);
    private final Collection<DispatcherFilter> dispatcherFilters = Lists.newArrayList();
    private final EventPark eventPark;

    public DispatcherFilterFactory(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map filterMap = context.getBeansOfType(DispatcherFilter.class);
        if (CollectionUtils.isEmpty((Map)filterMap)) {
            return;
        }
        Collection collection = filterMap.values();
        this.dispatcherFilters.addAll(collection.stream().sorted(new Comparator<DispatcherFilter>(){

            @Override
            public int compare(DispatcherFilter o1, DispatcherFilter o2) {
                DispatcherFilterCondition c1 = DispatcherFilterFactory.this.getAnnotation(o1);
                DispatcherFilterCondition c2 = DispatcherFilterFactory.this.getAnnotation(o2);
                if (Objects.isNull(c1) && Objects.nonNull(c2)) {
                    return -1;
                }
                if (Objects.nonNull(c1) && Objects.isNull(c2)) {
                    return 1;
                }
                if (Objects.isNull(c1) && Objects.isNull(c2)) {
                    return 0;
                }
                if (c1.probeOn() && !c2.probeOn()) {
                    return 1;
                }
                if (!c1.probeOn() && c2.probeOn()) {
                    return -1;
                }
                return 0;
            }
        }.thenComparing(Ordered::getOrder)).collect(Collectors.toList()));
        if (log.isInfoEnabled()) {
            this.dispatcherFilters.forEach(dispatcherFilter -> log.info("Registered DispatcherFilter: {} - {}", (Object)dispatcherFilter.getOrder(), dispatcherFilter));
        }
    }

    public void filter(DispatcherContext<Dispatcher> context) {
        HashSet trash = Sets.newHashSet();
        HashSet probeTrash = Sets.newHashSet();
        HashMap<Integer, Set<Dispatcher>> filterTrashMap = new HashMap<Integer, Set<Dispatcher>>(this.dispatcherFilters.size());
        this.dispatcherFilters.forEach(dispatcherFilter -> {
            String clazzSimpleName = ClassUtils.getUserClass((Object)dispatcherFilter).getSimpleName();
            DispatcherFilterCondition condition = this.getAnnotation((DispatcherFilter)dispatcherFilter);
            if (this.checkCondition(context, condition)) {
                if (log.isDebugEnabled()) {
                    log.debug("filter {} ignore", (Object)clazzSimpleName);
                }
                return;
            }
            dispatcherFilter.filter(context, trash);
            if (!CollectionUtils.isEmpty((Collection)trash)) {
                if (log.isDebugEnabled()) {
                    log.debug("filter {} trash {}", (Object)clazzSimpleName, trash.stream().map(Dispatcher::getId).collect(Collectors.toSet()));
                }
                if (Objects.nonNull(condition) && condition.probeOn()) {
                    probeTrash.addAll(trash);
                }
                context.getValues().removeIf(dispatcher -> trash.contains(dispatcher));
                int filterType = Arrays.stream(DispatcherFilterEnum.values()).filter((? super T filterEnum) -> filterEnum.name().equals(clazzSimpleName)).findFirst().orElse(DispatcherFilterEnum.Undefined).getType();
                ((Set)MapHelper.get(filterTrashMap, Integer.valueOf(filterType), new HashSet())).addAll(trash);
                trash.clear();
            }
            if (CollectionUtils.isEmpty(context.getValues())) {
                return;
            }
        });
        this.probe(context, probeTrash);
        if (!CollectionUtils.isEmpty(filterTrashMap)) {
            this.eventPark.post((EventObject)new AdxDispatcherFilter(this, context.getRequest(), filterTrashMap));
        }
        if (CollectionUtils.isEmpty(context.getValues())) {
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
    }

    private boolean checkCondition(DispatcherContext<Dispatcher> context, DispatcherFilterCondition condition) {
        Integer dmType = context.getPosition().getDockingMethodType();
        if (Objects.isNull(condition) || Objects.isNull(dmType)) {
            return false;
        }
        int[] dmTypes = condition.onDmType();
        return ArrayUtils.isNotEmpty((int[])dmTypes) && !ArrayUtils.contains((int[])dmTypes, (int)dmType);
    }

    private void probe(DispatcherContext<Dispatcher> context, Set<Dispatcher> probeTrash) {
        if (CollectionUtils.isEmpty(probeTrash)) {
            return;
        }
        int ratio = this.ratio();
        Set probeDispatcher = probeTrash.stream().filter((? super T dispatcher) -> Objects.nonNull(dispatcher.getProbe())).filter((? super T dispatcher) -> {
            if (log.isDebugEnabled()) {
                log.debug("Dispatcher {} probe {} user-probe {}", new Object[]{dispatcher.getId(), dispatcher.getProbe().movePointRight(2).intValue(), ratio});
            }
            return dispatcher.getProbe().movePointRight(2).intValue() > ratio;
        }).collect(Collectors.toSet());
        context.getValues().addAll(probeDispatcher);
    }

    private int ratio() {
        String uid = AdxContextFactory.get().getUid();
        uid = StringUtils.isEmpty((Object)uid) ? RandomStringUtils.randomAlphanumeric((int)8) : uid;
        int ratio = Math.abs(uid.hashCode() % 100);
        return ratio;
    }

    private DispatcherFilterCondition getAnnotation(DispatcherFilter filter) {
        DispatcherFilterCondition condition = (DispatcherFilterCondition)AnnotationUtils.findAnnotation((Class)ClassUtils.getUserClass((Object)filter), DispatcherFilterCondition.class);
        return condition;
    }
}

