/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching;

import com.bxm.adx.common.caching.AbstractLoadingCache;
import com.bxm.adx.common.caching.ChangedHandler;
import com.bxm.warcar.integration.listeners.AbstractNameBeanBus;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChangedHandlerLoadingCaching<T, Bus extends AbstractNameBeanBus<? extends ChangedHandler<T>>>
extends AbstractLoadingCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractChangedHandlerLoadingCaching.class);

    protected abstract AbstractNameBeanBus<? extends ChangedHandler<T>> getChangedHandlerFactory();

    @Override
    protected void afterUpdate(T old, T newest) {
        this.getChangedHandlerFactory().getAll().forEach(h -> {
            try {
                h.doUpdate(old, newest);
            }
            catch (Exception e) {
                log.error("doUpdate: ", (Throwable)e);
            }
        });
    }

    @Override
    protected void afterDelete(T old) {
        this.getChangedHandlerFactory().getAll().forEach(h -> {
            try {
                if (Objects.nonNull(old)) {
                    h.doDelete(old);
                }
            }
            catch (Exception e) {
                log.error("doDelete: ", (Throwable)e);
            }
        });
    }
}

