/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspCaching;
import com.bxm.adx.common.buy.dsp.DspChangedEvent;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DspDataSyncHandler
implements DataSyncHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DspDataSyncHandler.class);
    private final DspCaching dspCaching;
    private ApplicationContext applicationContext;

    public DspDataSyncHandler(DspCaching dspCaching) {
        this.dspCaching = dspCaching;
    }

    @Override
    public Class<?> getClazz() {
        return Dsp.class;
    }

    @Override
    public Object set(String key, Object object) {
        if (!(object instanceof Dsp)) {
            log.warn("object {} not support", object);
            return object;
        }
        Dsp dsp = (Dsp)object;
        if (dsp.isForbidden()) {
            this.dspCaching.del(dsp.getDspCode());
        } else {
            this.dspCaching.set(dsp.getDspCode(), dsp);
            this.applicationContext.publishEvent((ApplicationEvent)new DspChangedEvent(this, dsp));
        }
        return object;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

