/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.DealWrapper;
import com.bxm.adx.common.market.Market;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.exchange.ExchangeResult;
import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.filter.DealFilterFactory;
import com.bxm.adx.common.market.monitor.MonitorWrapper;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
public class DefaultMarketImpl
implements Market {
    private static final Logger log = LoggerFactory.getLogger(DefaultMarketImpl.class);
    private final PriorityExchanger priorityExchanger;
    private final DealFilterFactory dealFilterFactory;
    private final MonitorWrapper monitorWrapper;

    public DefaultMarketImpl(PriorityExchanger priorityExchanger, DealFilterFactory dealFilterFactory, MonitorWrapper monitorWrapper) {
        this.priorityExchanger = priorityExchanger;
        this.dealFilterFactory = dealFilterFactory;
        this.monitorWrapper = monitorWrapper;
    }

    @Override
    public BidResponse exchange(MarketOrders orders) {
        if (CollectionUtils.isEmpty(orders.getPositions())) {
            if (log.isDebugEnabled()) {
                log.debug("positions is null {} ", orders.getBidRequest().getImps());
            }
            return null;
        }
        List<Deal> deals = null;
        ExchangeResult exchangeResult = this.priorityExchanger.exchange(orders);
        boolean previewStatus = exchangeResult.exchangeSuccess();
        this.dealFilterFactory.filter(orders, exchangeResult);
        if (!exchangeResult.exchangeSuccess()) {
            if (previewStatus) {
                throw new AdxException(AdxErrEnum.ADX_EMPTY_RESPONSE);
            }
            throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
        }
        deals = exchangeResult.getDeals();
        BidResponse bidResponse = DealWrapper.merge(deals);
        return bidResponse;
    }
}

