/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TaskIdDispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(TaskIdDispatcherPriceConfigFilter.class);

    public int getOrder() {
        return 10;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        String taskId = bid.getTask_id();
        Integer userScoreLevel = bid.getUser_score_level();
        if (log.isDebugEnabled()) {
            log.debug(" adid:{},taskId:{},userScoreLevel:{}", new Object[]{bid.getAdid(), taskId, userScoreLevel});
        }
        priceConfigs.removeIf(config -> config.getFilterMode() != null && 1 == config.getFilterMode() && !this.getPriceConfig((DispatcherPriceConfig)config, taskId, userScoreLevel));
    }

    private boolean getPriceConfig(DispatcherPriceConfig config, String taskId, Integer userScoreLevel) {
        List<String> taskIds = config.getTaskIds();
        if (CollectionUtils.isEmpty(taskIds)) {
            return false;
        }
        String interval = this.locateInterval(userScoreLevel);
        return taskIds.contains(taskId) || taskIds.contains(interval) || taskIds.contains(taskId + ":" + interval);
    }

    public String locateInterval(Integer number) {
        if (number == null) {
            return "";
        }
        if (number >= 81 && number <= 100) {
            return "81_100";
        }
        if (number >= 61 && number <= 80) {
            return "61_80";
        }
        if (number >= 41 && number <= 60) {
            return "41_60";
        }
        if (number >= 21 && number <= 40) {
            return "21_40";
        }
        if (number >= 1 && number <= 20) {
            return "1_20";
        }
        return String.valueOf(number);
    }
}

