/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RequestBuilder
implements AdxBidRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(RequestBuilder.class);
    private final AdvertPointService advertPointService;

    public RequestBuilder(AdvertPointService advertPointService) {
        this.advertPointService = advertPointService;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        adxBidRequest.setBid_model(this.getBidModel(attribute));
    }

    private Integer getBidModel(RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = this.advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        if (Objects.isNull(advertPoint)) {
            log.error("dispatcher {} err", (Object)dispatcher.getId());
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        Integer costPerType = Optional.ofNullable(advertPoint.getCostPerType()).orElse(1);
        if (Objects.nonNull(costPerType)) {
            switch (costPerType) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            log.error("unsupport type {} err", (Object)costPerType);
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
        log.warn("advert-point {} cost-type is empty", (Object)advertPoint.getUniqueKey());
        return 1;
    }
}

