/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.ClickMonitor;
import com.bxm.adx.common.sell.response.ImpMonitor;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.warcar.integration.pair.Pair;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BesDomainFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BesDomainFilter.class);
    private final Pair pair;
    private static final String KEY = "adx.bes.domain.list";

    public BesDomainFilter(Pair pair) {
        this.pair = pair;
    }

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        BidRequest request = AdxContextFactory.get().getBidRequest();
        String mediaId = request.getMediaId();
        if (StringUtils.isEmpty((String)mediaId) || !mediaId.equals(String.valueOf(AdxConstants.Media.Bes.getId()))) {
            return;
        }
        Set domainSet = this.pair.get(KEY).ofHashSet();
        if (CollectionUtils.isEmpty((Collection)domainSet)) {
            return;
        }
        Set remove = deals.stream().filter(deal -> {
            BidResponse response = deal.getBidResponse();
            List<SeatBid> seatBidList = response.getSeat_bid();
            seatBidList.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                bidList.removeIf(bid -> this.checkDomain(this.getUrlList((Bid)bid), domainSet));
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBidList);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private List<String> getUrlList(Bid bid) {
        String clickThroughUrl;
        List<ClickMonitor> clickMonitors;
        ArrayList urls = Lists.newArrayList();
        List<ImpMonitor> impMonitors = bid.getImp_monitors();
        if (CollectionUtils.isNotEmpty(impMonitors)) {
            urls.addAll(impMonitors.stream().map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(clickMonitors = bid.getClick_monitors())) {
            urls.addAll(clickMonitors.stream().map(ClickMonitor::getClick_monitor_url).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)(clickThroughUrl = bid.getClick_through_url()))) {
            urls.add(clickThroughUrl);
        }
        return urls;
    }

    private boolean checkDomain(List<String> urls, Set<String> domains) {
        for (String url : urls) {
            String host = null;
            try {
                host = URI.create(url).getHost();
            }
            catch (Exception e) {
                continue;
            }
            if (!StringUtils.isNotEmpty((String)host)) continue;
            boolean b = true;
            for (String domain : domains) {
                if (!host.contains(domain)) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return true;
        }
        return false;
    }
}

