/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CpcPriceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CpcPriceFilter.class);
    @Resource
    private AdxProperties properties;

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        BidRequest request = AdxContextFactory.get().getBidRequest();
        int bidModel = request.getBid_model();
        if (2 != bidModel && 3 != bidModel) {
            return;
        }
        List bidList = deals.stream().filter(deal -> Objects.nonNull(deal.getBidResponse())).map(Deal::getBidResponse).filter(bidResponse -> CollectionUtils.isNotEmpty(bidResponse.getSeat_bid())).map(BidResponse::getSeat_bid).flatMap(Collection::stream).filter(seatBid -> CollectionUtils.isNotEmpty(seatBid.getBid())).map(SeatBid::getBid).flatMap(Collection::stream).filter(bid -> 2 == bid.getCharge_type() && Objects.nonNull(bid.getBid())).sorted(Comparator.comparing(Bid::getBid).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bidList) || bidList.size() <= this.properties.getMaxCreativesOfCpc()) {
            return;
        }
        HashSet bidSet = new HashSet(bidList);
        if (bidSet.size() != bidList.size()) {
            log.warn("bid id&adid is duplicate");
        }
        List removeList = new ArrayList(bidList).subList(this.properties.getMaxCreativesOfCpc(), bidList.size());
        Set remove = deals.stream().filter(deal -> {
            BidResponse response = deal.getBidResponse();
            List<SeatBid> seatBids = response.getSeat_bid();
            seatBids.removeIf(seatBid -> {
                List<Bid> bids = seatBid.getBid();
                bids.removeIf(b -> removeList.contains(b));
                return CollectionUtils.isEmpty(bids);
            });
            return CollectionUtils.isEmpty(seatBids);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

