/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@DealFilterCondition(preview=true)
public class ExceptionDealFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionDealFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set remove = deals.stream().filter(deal -> Objects.nonNull(deal.getAdxErrEnum())).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

