/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.DealFilterCondition;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@DealFilterCondition(preview=true)
public class PriceBidFloorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriceBidFloorFilter.class);

    @Override
    public void filter(List<Deal> deals, Set<Deal> trash) {
        Set remove = deals.stream().filter(deal -> {
            BidResponse response = deal.getBidResponse();
            BidRequest request = deal.getBidRequest();
            List<SeatBid> seatBids = response.getSeat_bid();
            seatBids.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                bidList.removeIf(bid -> {
                    boolean isCpc = this.isCpc((Bid)bid);
                    BigDecimal price = null;
                    price = !isCpc ? bid.getPrice() : bid.getBid();
                    if (Objects.isNull(price) || price.compareTo(BigDecimal.ZERO) == 0) {
                        return true;
                    }
                    BigDecimal bidFloor = null;
                    if (this.isApi(request)) {
                        bidFloor = !isCpc ? request.getImps().iterator().next().getBid_floor() : request.getImps().iterator().next().getCpc_bid_floor();
                    }
                    return Objects.nonNull(bidFloor) && price.compareTo(bidFloor) < 0;
                });
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBids);
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return 1;
    }

    private boolean isApi(BidRequest request) {
        return Objects.nonNull(request.getDockingMethodType()) && DockingMethodTypeEnum.API_OPERATION.getType().equals(request.getDockingMethodType());
    }

    private boolean isCpc(Bid bid) {
        int chargeType = bid.getCharge_type();
        return 2 == chargeType;
    }
}

