/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.market.exchange.Exchanger;
import com.bxm.adx.common.micrometer.aspect.ExchangeMicroMeter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ExchangeMicroMeterAspect {
    private static final Logger log = LoggerFactory.getLogger(ExchangeMicroMeterAspect.class);
    private final ExchangeMicroMeter microMeter;

    public ExchangeMicroMeterAspect(ExchangeMicroMeter microMeter) {
        this.microMeter = microMeter;
    }

    @Pointcut(value="this(com.bxm.adx.common.market.exchange.Exchanger) && execution(* bidding(..))")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof Exchanger)) {
            return point.proceed();
        }
        Exchanger exchanger = (Exchanger)target;
        this.counterBuyer(point.getArgs(), exchanger);
        Timer timer = this.microMeter.getTimer(exchanger);
        long start = System.nanoTime();
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            if (Objects.nonNull(timer)) {
                timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    private void counterBuyer(Object[] args, Exchanger exchanger) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return;
        }
        Object arg = args[1];
        if (Objects.isNull(arg)) {
            return;
        }
        if (arg instanceof Collection) {
            Collection collection = (Collection)arg;
            this.microMeter.getCounter(exchanger).increment((double)collection.size());
        }
    }
}

