/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.event.internal;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.EventObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DspNbrEvent
extends EventObject {
    private static final Logger log = LoggerFactory.getLogger(DspNbrEvent.class);
    private final BidRequest sspRequest;
    private final BidRequest adxRequest;
    private String dspResponse;
    private final Long dspId;

    public DspNbrEvent(Object source, BidRequest sspRequest, BidRequest adxRequest, BidResponse dspResponse, Long dspId) {
        super(source);
        this.sspRequest = sspRequest;
        this.adxRequest = adxRequest;
        this.dspId = dspId;
        this.dspResponse = this.serialize(dspResponse);
    }

    private String serialize(BidResponse dspResponse) {
        try {
            String json = new ObjectMapper().writeValueAsString((Object)dspResponse);
            return json;
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public BidRequest getSspRequest() {
        return this.sspRequest;
    }

    public BidRequest getAdxRequest() {
        return this.adxRequest;
    }

    public BidResponse getDspResponse() {
        if (StringUtils.isNotEmpty((String)this.dspResponse)) {
            try {
                return (BidResponse)new ObjectMapper().readValue(this.dspResponse, BidResponse.class);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Long getDspId() {
        return this.dspId;
    }
}

