/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DotDspBidForDeviceEventListener
implements EventListener<DspBidEvent> {
    private final InsertExpireHandler insertExpireHandler;
    private final Properties properties = new Properties();

    public DotDspBidForDeviceEventListener(@Qualifier(value="insertExpireDeviceCrowdPackageHandler") InsertExpireHandler insertExpireHandler) {
        this.insertExpireHandler = insertExpireHandler;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        Long dspId = event.getDspId();
        if (dspId.equals(this.properties.dspId)) {
            String crowdId = this.properties.getCrowdId();
            LocalDate now = LocalDate.now();
            if (now.isBefore(this.properties.getStart()) || now.isAfter(this.properties.getEnd())) {
                return;
            }
            KeyGenerator key = CacheKeys.getCrowdPackageNewKey(event.getSspRequest().getDevice());
            if (Objects.nonNull(key)) {
                long crowdExpire = this.getExpire();
                long keyExpire = crowdExpire - System.currentTimeMillis() / 1000L;
                this.insertExpireHandler.insert(key, crowdId, crowdExpire + "", (int)keyExpire);
            }
        }
    }

    private long getExpire() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oneWeekLater = now.plus(1L, ChronoUnit.WEEKS);
        ZoneId currentZone = ZoneId.systemDefault();
        long timestamp = oneWeekLater.atZone(currentZone).toInstant().toEpochMilli() / 1000L;
        return timestamp;
    }

    static class Properties {
        private Long dspId = 103L;
        private String crowdId = "184";
        private LocalDate start = LocalDate.of(2024, 7, 22);
        private LocalDate end = LocalDate.of(2024, 7, 29);

        public Long getDspId() {
            return this.dspId;
        }

        public String getCrowdId() {
            return this.crowdId;
        }

        public LocalDate getStart() {
            return this.start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public void setDspId(Long dspId) {
            this.dspId = dspId;
        }

        public void setCrowdId(String crowdId) {
            this.crowdId = crowdId;
        }

        public void setStart(LocalDate start) {
            this.start = start;
        }

        public void setEnd(LocalDate end) {
            this.end = end;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$dspId = this.getDspId();
            Long other$dspId = other.getDspId();
            if (this$dspId == null ? other$dspId != null : !((Object)this$dspId).equals(other$dspId)) {
                return false;
            }
            String this$crowdId = this.getCrowdId();
            String other$crowdId = other.getCrowdId();
            if (this$crowdId == null ? other$crowdId != null : !this$crowdId.equals(other$crowdId)) {
                return false;
            }
            LocalDate this$start = this.getStart();
            LocalDate other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            LocalDate this$end = this.getEnd();
            LocalDate other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $dspId = this.getDspId();
            result = result * 59 + ($dspId == null ? 43 : ((Object)$dspId).hashCode());
            String $crowdId = this.getCrowdId();
            result = result * 59 + ($crowdId == null ? 43 : $crowdId.hashCode());
            LocalDate $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            LocalDate $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            return result;
        }

        public String toString() {
            return "DotDspBidForDeviceEventListener.Properties(dspId=" + this.getDspId() + ", crowdId=" + this.getCrowdId() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

