/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotDspBidForUslEventListener
implements EventListener<DspBidEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotDspBidForUslEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspBidEvent event) {
        MultiValueMap<String, String> customizeParams = this.buildCustomizeParams(event.getDspResponse());
        if (MapUtils.isEmpty(customizeParams)) {
            return;
        }
        String url = this.properties.getOpenLog().createNeed(true, 32, customizeParams, OpenlogConstants.DSP_BID_USL_WITH_MACROS);
        BuildAttribute attribute = new BuildAttribute(3).setSspRequest(event.getSspRequest());
        url = this.macrosHandler.replaceAll(url, attribute);
        this.openLogClient.asyncRequest(url);
    }

    private MultiValueMap<String, String> buildCustomizeParams(BidResponse bidResponse) {
        List<Creative> creatives = this.getCreatives(bidResponse);
        if (CollectionUtils.isEmpty(creatives)) {
            return null;
        }
        LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
        String value = UrlHelper.urlEncode((String)JsonHelper.convert(creatives));
        customizeParams.add((Object)"creatives", (Object)value);
        return customizeParams;
    }

    private List<Creative> getCreatives(BidResponse bidResponse) {
        ArrayList<Creative> creatives = new ArrayList<Creative>();
        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                Integer userScoreLevel = bid.getUser_score_level();
                if (Objects.isNull(userScoreLevel) || userScoreLevel < 80) continue;
                Creative creative = new Creative().setUsl(bid.getUser_score_level());
                creatives.add(creative);
            }
        }
        return creatives;
    }

    private static class Creative {
        private Integer usl;

        public Integer getUsl() {
            return this.usl;
        }

        public Creative setUsl(Integer usl) {
            this.usl = usl;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Creative)) {
                return false;
            }
            Creative other = (Creative)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$usl = this.getUsl();
            Integer other$usl = other.getUsl();
            return !(this$usl == null ? other$usl != null : !((Object)this$usl).equals(other$usl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Creative;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $usl = this.getUsl();
            result = result * 59 + ($usl == null ? 43 : ((Object)$usl).hashCode());
            return result;
        }

        public String toString() {
            return "DotDspBidForUslEventListener.Creative(usl=" + this.getUsl() + ")";
        }
    }
}

