/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.report;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.ServerReportProperties;
import com.bxm.adx.common.openlog.event.internal.DspWinEvent;
import com.bxm.adx.common.report.DspWinInfo;
import com.bxm.adx.common.report.DspWinPriceHandler;
import com.bxm.adx.common.report.ReportClient;
import com.bxm.adx.common.report.ReportFallback;
import com.bxm.adx.common.report.ReportParam;
import com.bxm.adx.common.report.ReportType;
import com.bxm.adx.common.report.ServerReportConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

public class ServerReportService {
    private static final Logger log = LoggerFactory.getLogger(ServerReportService.class);
    private final JedisPool jedisPool;
    private final ReportClient reportClient;
    private final ServerReportProperties serverReportProperties;
    private final AdxProperties properties;
    private final EventPark eventPark;
    private final DspWinPriceHandler dspWinPriceHandler;

    public ServerReportService(ServerReportProperties serverReportProperties, JedisPool jedisPool, ReportClient reportClient, AdxProperties properties, EventPark eventPark, DspWinPriceHandler dspWinPriceHandler) {
        this.serverReportProperties = serverReportProperties;
        this.jedisPool = jedisPool;
        this.reportClient = reportClient;
        this.properties = properties;
        this.eventPark = eventPark;
        this.dspWinPriceHandler = dspWinPriceHandler;
    }

    public void report(ReportParam reportParam, MultiValueMap<String, String> headers, KeyValueMap map) {
        int success;
        Integer chargeType = reportParam.getChargeType();
        ReportType type = reportParam.getType();
        String bidId = reportParam.getBidId();
        String adId = reportParam.getAdId();
        String dspPriceKey = this.properties.getCipherProperties().getDspPriceKey();
        BigDecimal win = reportParam.getDspWinPrice(dspPriceKey);
        String dspId = reportParam.getDspId();
        KeyGenerator keyGenerator = null;
        if (Objects.isNull(chargeType)) {
            log.warn("charge-type is null, bidid = {}", (Object)bidId);
            keyGenerator = this.getKeyGenerator(type, bidId);
        } else {
            switch (chargeType) {
                case 2: {
                    if (StringUtils.isEmpty((Object)adId)) {
                        log.warn("adid is null, bidid = {}", (Object)bidId);
                        keyGenerator = this.getKeyGenerator(type, bidId);
                        break;
                    }
                    keyGenerator = this.getKeyGenerator(type, bidId, adId);
                    break;
                }
                default: {
                    keyGenerator = this.getKeyGenerator(type, bidId);
                }
            }
        }
        DspWinInfo dspWinInfo = null;
        if (Objects.nonNull(win)) {
            dspWinInfo = this.dspWinPriceHandler.handle(win, Long.valueOf(dspId));
            if (Objects.isNull(dspId)) {
                log.warn("dsp win info is null, bidid = {} type = {}", (Object)bidId, (Object)type.name());
            }
        }
        if ((success = this.report(keyGenerator.generateKey(), headers, dspWinInfo)) == 0) {
            log.warn("report param {} empty", (Object)reportParam);
        }
        this.eventPark.post((EventObject)new DspWinEvent(this, win, (MultiValueMap<String, String>)new LinkedMultiValueMap((Map)map), success > 0));
    }

    /*
     * Loose catch block
     */
    private int report(String key, MultiValueMap<String, String> headers, DspWinInfo info) {
        BasicHeader[] basicHeaders = this.convertToBasicHeaders(headers);
        int success = 0;
        block13: while (true) {
            try {
                Throwable throwable;
                Jedis jedis;
                while (true) {
                    block22: {
                        String url;
                        block20: {
                            block21: {
                                jedis = this.jedisPool.getResource();
                                throwable = null;
                                jedis.select(this.serverReportProperties.getQueueDb());
                                url = jedis.lpop(key);
                                if (!StringUtils.isEmpty((Object)url)) break block20;
                                if (jedis == null) break block13;
                                if (throwable == null) break block21;
                                try {
                                    jedis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block13;
                            }
                            jedis.close();
                            break block13;
                        }
                        if (Objects.nonNull(info)) {
                            url = url.replace(info.getMacro(), info.getCipher());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("report url {}", (Object)url);
                        }
                        this.reportClient.asyncRequest(url, new Consumer<ReportFallback>(){

                            @Override
                            public void accept(ReportFallback reportFallback) {
                                IOException exception = reportFallback.getException();
                                log.warn("report fail {} url {}, headers {}", new Object[]{exception == null ? "" : exception.getMessage(), reportFallback.getUrl(), reportFallback.getHeaders()});
                            }
                        }, (Header[])basicHeaders);
                        ++success;
                        if (jedis == null) continue;
                        if (throwable == null) break block22;
                        try {
                            jedis.close();
                            continue block13;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            continue;
                        }
                    }
                    jedis.close();
                }
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (jedis != null) {
                            if (throwable != null) {
                                try {
                                    jedis.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                jedis.close();
                            }
                        }
                        throw throwable5;
                    }
                }
            }
            catch (Exception e) {
                log.error("report err {}, affect {} {}", new Object[]{e.getMessage(), key, headers});
                continue;
            }
            break;
        }
        return success;
    }

    public void saveExceed(ReportParam reportParam, List<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return;
        }
        KeyGenerator keyGenerator = null;
        Integer chargeType = reportParam.getChargeType();
        ReportType type = reportParam.getType();
        String bidId = reportParam.getBidId();
        String adId = reportParam.getAdId();
        switch (chargeType) {
            case 1: {
                keyGenerator = this.getKeyGenerator(type, bidId);
                break;
            }
            default: {
                keyGenerator = this.getKeyGenerator(type, bidId, adId);
            }
        }
        this.save(keyGenerator.generateKey(), urls);
    }

    private void save(String key, List<String> urls) {
        try (Jedis jedis = this.jedisPool.getResource();
             Pipeline pipeline = jedis.pipelined();){
            pipeline.select(this.serverReportProperties.getQueueDb());
            pipeline.lpush(key, urls.toArray(new String[0]));
            pipeline.expire(key, this.serverReportProperties.getExpire());
            List response = pipeline.syncAndReturnAll();
            if (log.isDebugEnabled()) {
                log.debug("pipeline response {}", (Object)response);
            }
        }
        catch (Exception e) {
            log.error("save exceed err {}, affect {}", (Object)e.getMessage(), urls);
        }
    }

    public KeyGenerator getKeyGenerator(ReportType type, String id) {
        return CacheKeys.ServerReport.getServerReportTempKey(type.name(), id);
    }

    public KeyGenerator getKeyGenerator(ReportType type, String id, String adId) {
        return CacheKeys.ServerReport.getServerReportTempKey(type.name(), id, adId);
    }

    public ServerReportConfig getConfig(String mediaId, String appId, String dspId, String bidId) {
        ServerReportProperties.MediaConfig mediaConfig = this.getMedia(mediaId, appId);
        if (Objects.isNull(mediaConfig)) {
            return null;
        }
        if (!this.serverReportProperties.getDspIds().contains(dspId)) {
            return null;
        }
        return ServerReportConfig.builder().limit(mediaConfig.getNum() - 1).bidId(bidId).domains(this.serverReportProperties.getDomains()).appId(appId).dspId(dspId).mediaId(mediaId).build();
    }

    private ServerReportProperties.MediaConfig getMedia(String mediaId, String appId) {
        List<ServerReportProperties.MediaConfig> media = this.serverReportProperties.getMedia();
        for (ServerReportProperties.MediaConfig config : media) {
            if (!mediaId.equals(config.getId())) continue;
            List<String> appIds = config.getAppIds();
            if (CollectionUtils.isNotEmpty(appIds)) {
                if (!appIds.contains(appId)) continue;
                return config;
            }
            return config;
        }
        return null;
    }

    public BasicHeader[] convertToBasicHeaders(MultiValueMap<String, String> map) {
        BasicHeader[] headers = new BasicHeader[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            CharSequence[] values = ((List)map.get((Object)key)).toArray(new String[0]);
            headers[i] = new BasicHeader(key, String.join((CharSequence)", ", values));
            ++i;
        }
        return headers;
    }

    static class Request {
        private String url;
        private BasicHeader[] headers;

        public static RequestBuilder builder() {
            return new RequestBuilder();
        }

        public String getUrl() {
            return this.url;
        }

        public BasicHeader[] getHeaders() {
            return this.headers;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHeaders(BasicHeader[] headers) {
            this.headers = headers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            return Arrays.deepEquals(this.getHeaders(), other.getHeaders());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getHeaders());
            return result;
        }

        public String toString() {
            return "ServerReportService.Request(url=" + this.getUrl() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ")";
        }

        public Request(String url, BasicHeader[] headers) {
            this.url = url;
            this.headers = headers;
        }

        public Request() {
        }

        public static class RequestBuilder {
            private String url;
            private BasicHeader[] headers;

            RequestBuilder() {
            }

            public RequestBuilder url(String url) {
                this.url = url;
                return this;
            }

            public RequestBuilder headers(BasicHeader[] headers) {
                this.headers = headers;
                return this;
            }

            public Request build() {
                return new Request(this.url, this.headers);
            }

            public String toString() {
                return "ServerReportService.Request.RequestBuilder(url=" + this.url + ", headers=" + Arrays.deepToString(this.headers) + ")";
            }
        }
    }
}

