/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.builder;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BuildAttribute {
    private BidRequest sspRequest;
    private BidRequest adxRequest;
    private BidResponse adxResponse;
    private BidResponse dspResponse;
    private BigDecimal sspRequestPrice;
    private BigDecimal adxRequestPrice;
    private BigDecimal dspResponsePrice;
    private BigDecimal adxResponsePrice;
    private Long configId;
    private String algoFlowControlBucket;
    private Long dspId;
    private String appId;
    private String tagId;
    private String dAppId;
    private String dTagId;
    private Integer mt;
    private String mediaId;
    private Long dispatcherId;
    private Long strategyId;
    private SeatBid seatBid;
    private Bid bid;

    public BuildAttribute(Integer mt) {
        this.mt = mt;
    }

    public BuildAttribute() {
    }

    public String getAppId() {
        if (Objects.isNull(this.sspRequest)) {
            return null;
        }
        App app = this.sspRequest.getApp();
        if (Objects.nonNull(app)) {
            return app.getId();
        }
        return null;
    }

    public String getTagId() {
        if (Objects.isNull(this.sspRequest)) {
            return null;
        }
        List<Impression> impressions = this.sspRequest.getImps();
        if (CollectionUtils.isNotEmpty(impressions)) {
            return impressions.iterator().next().getTag_id();
        }
        return null;
    }

    public String getdAppId() {
        String appid;
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        App app;
        if (Objects.nonNull(this.adxRequest) && Objects.nonNull(app = this.adxRequest.getApp())) {
            return app.getId();
        }
        if (Objects.nonNull(this.bid)) {
            return this.bid.getDsp_appid();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid()) && !StringUtils.isEmpty((CharSequence)(appid = bids.iterator().next().getDsp_appid()))) {
            return appid;
        }
        return null;
    }

    public String getdTagId() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        List<Impression> impressions;
        if (StringUtils.isNotEmpty((CharSequence)this.dTagId)) {
            return this.dTagId;
        }
        if (Objects.nonNull(this.adxRequest) && CollectionUtils.isNotEmpty(impressions = this.adxRequest.getImps())) {
            return impressions.iterator().next().getTag_id();
        }
        if (Objects.nonNull(this.bid)) {
            return this.bid.getTag_id();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getTag_id();
        }
        return null;
    }

    public BigDecimal getSspRequestPrice() {
        List<Impression> impressions;
        if (Objects.nonNull(this.sspRequest) && CollectionUtils.isNotEmpty(impressions = this.sspRequest.getImps())) {
            return impressions.iterator().next().getBid_floor();
        }
        return null;
    }

    public BigDecimal getAdxRequestPrice() {
        List<Impression> impressions;
        if (Objects.nonNull(this.adxRequest) && CollectionUtils.isNotEmpty(impressions = this.adxRequest.getImps())) {
            return impressions.iterator().next().getBid_floor();
        }
        return null;
    }

    @Deprecated
    public BigDecimal getDspResponsePrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.dspResponse) && CollectionUtils.isNotEmpty(seatBids = this.dspResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDsp_price();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDsp_price();
        }
        return null;
    }

    public BigDecimal getDspResponseWinPrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.bid)) {
            return this.bid.getDspWinPrice();
        }
        if (Objects.nonNull(this.dspResponse) && CollectionUtils.isNotEmpty(seatBids = this.dspResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDspWinPrice();
        }
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getDspWinPrice();
        }
        return null;
    }

    @Deprecated
    private BigDecimal getAdxResponsePrice() {
        SeatBid seatBid;
        List<Bid> bids;
        List<SeatBid> seatBids;
        if (Objects.nonNull(this.adxResponse) && CollectionUtils.isNotEmpty(seatBids = this.adxResponse.getSeat_bid()) && CollectionUtils.isNotEmpty(bids = (seatBid = seatBids.iterator().next()).getBid())) {
            return bids.iterator().next().getPrice();
        }
        return null;
    }

    public String getPrice() {
        if (Objects.nonNull(this.mt)) {
            switch (this.mt) {
                case 1: {
                    return this.getSspRequestPrice().toString();
                }
                case 2: {
                    return this.getAdxRequestPrice().toString();
                }
                case 3: {
                    return this.getDspResponsePrice().toString();
                }
                case 4: {
                    return this.getAdxResponsePrice().toString();
                }
            }
            return null;
        }
        return null;
    }

    public String getMediaId() {
        if (Objects.nonNull(this.sspRequest)) {
            return this.sspRequest.getMediaId();
        }
        if (Objects.nonNull(this.adxRequest)) {
            return this.adxRequest.getMediaId();
        }
        return null;
    }

    public Integer getMediaChargeType() {
        if (Objects.isNull(this.bid)) {
            return null;
        }
        return this.bid.getCharge_type();
    }

    public Integer getDspChargeType() {
        if (Objects.isNull(this.bid)) {
            return null;
        }
        return this.bid.getDsp_charge_type();
    }

    public Long getConfigId() {
        if (Objects.nonNull(this.configId)) {
            return this.configId;
        }
        if (Objects.nonNull(this.mt)) {
            switch (this.mt) {
                case 3: {
                    return this.dspResponse.getSeat_bid().iterator().next().getConfigId();
                }
            }
            return this.configId;
        }
        return this.configId;
    }

    public String getAlgoFlowControlBucket() {
        if (StringUtils.isNotBlank((CharSequence)this.algoFlowControlBucket)) {
            return this.algoFlowControlBucket;
        }
        if (Objects.nonNull(this.mt)) {
            switch (this.mt) {
                case 3: {
                    return this.dspResponse.getSeat_bid().iterator().next().getAlgoFlowControlBucket();
                }
            }
            return this.algoFlowControlBucket;
        }
        return this.algoFlowControlBucket;
    }

    public BidRequest getSspRequest() {
        return this.sspRequest;
    }

    public BidRequest getAdxRequest() {
        return this.adxRequest;
    }

    public BidResponse getAdxResponse() {
        return this.adxResponse;
    }

    public BidResponse getDspResponse() {
        return this.dspResponse;
    }

    public Long getDspId() {
        return this.dspId;
    }

    public Integer getMt() {
        return this.mt;
    }

    public Long getDispatcherId() {
        return this.dispatcherId;
    }

    public Long getStrategyId() {
        return this.strategyId;
    }

    public SeatBid getSeatBid() {
        return this.seatBid;
    }

    public Bid getBid() {
        return this.bid;
    }

    public BuildAttribute setSspRequest(BidRequest sspRequest) {
        this.sspRequest = sspRequest;
        return this;
    }

    public BuildAttribute setAdxRequest(BidRequest adxRequest) {
        this.adxRequest = adxRequest;
        return this;
    }

    public BuildAttribute setAdxResponse(BidResponse adxResponse) {
        this.adxResponse = adxResponse;
        return this;
    }

    public BuildAttribute setDspResponse(BidResponse dspResponse) {
        this.dspResponse = dspResponse;
        return this;
    }

    public BuildAttribute setSspRequestPrice(BigDecimal sspRequestPrice) {
        this.sspRequestPrice = sspRequestPrice;
        return this;
    }

    public BuildAttribute setAdxRequestPrice(BigDecimal adxRequestPrice) {
        this.adxRequestPrice = adxRequestPrice;
        return this;
    }

    public BuildAttribute setDspResponsePrice(BigDecimal dspResponsePrice) {
        this.dspResponsePrice = dspResponsePrice;
        return this;
    }

    public BuildAttribute setAdxResponsePrice(BigDecimal adxResponsePrice) {
        this.adxResponsePrice = adxResponsePrice;
        return this;
    }

    public BuildAttribute setConfigId(Long configId) {
        this.configId = configId;
        return this;
    }

    public BuildAttribute setAlgoFlowControlBucket(String algoFlowControlBucket) {
        this.algoFlowControlBucket = algoFlowControlBucket;
        return this;
    }

    public BuildAttribute setDspId(Long dspId) {
        this.dspId = dspId;
        return this;
    }

    public BuildAttribute setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public BuildAttribute setTagId(String tagId) {
        this.tagId = tagId;
        return this;
    }

    public BuildAttribute setDAppId(String dAppId) {
        this.dAppId = dAppId;
        return this;
    }

    public BuildAttribute setDTagId(String dTagId) {
        this.dTagId = dTagId;
        return this;
    }

    public BuildAttribute setMt(Integer mt) {
        this.mt = mt;
        return this;
    }

    public BuildAttribute setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public BuildAttribute setDispatcherId(Long dispatcherId) {
        this.dispatcherId = dispatcherId;
        return this;
    }

    public BuildAttribute setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
        return this;
    }

    public BuildAttribute setSeatBid(SeatBid seatBid) {
        this.seatBid = seatBid;
        return this;
    }

    public BuildAttribute setBid(Bid bid) {
        this.bid = bid;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildAttribute)) {
            return false;
        }
        BuildAttribute other = (BuildAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$configId = this.getConfigId();
        Long other$configId = other.getConfigId();
        if (this$configId == null ? other$configId != null : !((Object)this$configId).equals(other$configId)) {
            return false;
        }
        Long this$dspId = this.getDspId();
        Long other$dspId = other.getDspId();
        if (this$dspId == null ? other$dspId != null : !((Object)this$dspId).equals(other$dspId)) {
            return false;
        }
        Integer this$mt = this.getMt();
        Integer other$mt = other.getMt();
        if (this$mt == null ? other$mt != null : !((Object)this$mt).equals(other$mt)) {
            return false;
        }
        Long this$dispatcherId = this.getDispatcherId();
        Long other$dispatcherId = other.getDispatcherId();
        if (this$dispatcherId == null ? other$dispatcherId != null : !((Object)this$dispatcherId).equals(other$dispatcherId)) {
            return false;
        }
        Long this$strategyId = this.getStrategyId();
        Long other$strategyId = other.getStrategyId();
        if (this$strategyId == null ? other$strategyId != null : !((Object)this$strategyId).equals(other$strategyId)) {
            return false;
        }
        BidRequest this$sspRequest = this.getSspRequest();
        BidRequest other$sspRequest = other.getSspRequest();
        if (this$sspRequest == null ? other$sspRequest != null : !((Object)this$sspRequest).equals(other$sspRequest)) {
            return false;
        }
        BidRequest this$adxRequest = this.getAdxRequest();
        BidRequest other$adxRequest = other.getAdxRequest();
        if (this$adxRequest == null ? other$adxRequest != null : !((Object)this$adxRequest).equals(other$adxRequest)) {
            return false;
        }
        BidResponse this$adxResponse = this.getAdxResponse();
        BidResponse other$adxResponse = other.getAdxResponse();
        if (this$adxResponse == null ? other$adxResponse != null : !((Object)this$adxResponse).equals(other$adxResponse)) {
            return false;
        }
        BidResponse this$dspResponse = this.getDspResponse();
        BidResponse other$dspResponse = other.getDspResponse();
        if (this$dspResponse == null ? other$dspResponse != null : !((Object)this$dspResponse).equals(other$dspResponse)) {
            return false;
        }
        BigDecimal this$sspRequestPrice = this.getSspRequestPrice();
        BigDecimal other$sspRequestPrice = other.getSspRequestPrice();
        if (this$sspRequestPrice == null ? other$sspRequestPrice != null : !((Object)this$sspRequestPrice).equals(other$sspRequestPrice)) {
            return false;
        }
        BigDecimal this$adxRequestPrice = this.getAdxRequestPrice();
        BigDecimal other$adxRequestPrice = other.getAdxRequestPrice();
        if (this$adxRequestPrice == null ? other$adxRequestPrice != null : !((Object)this$adxRequestPrice).equals(other$adxRequestPrice)) {
            return false;
        }
        BigDecimal this$dspResponsePrice = this.getDspResponsePrice();
        BigDecimal other$dspResponsePrice = other.getDspResponsePrice();
        if (this$dspResponsePrice == null ? other$dspResponsePrice != null : !((Object)this$dspResponsePrice).equals(other$dspResponsePrice)) {
            return false;
        }
        BigDecimal this$adxResponsePrice = this.getAdxResponsePrice();
        BigDecimal other$adxResponsePrice = other.getAdxResponsePrice();
        if (this$adxResponsePrice == null ? other$adxResponsePrice != null : !((Object)this$adxResponsePrice).equals(other$adxResponsePrice)) {
            return false;
        }
        String this$algoFlowControlBucket = this.getAlgoFlowControlBucket();
        String other$algoFlowControlBucket = other.getAlgoFlowControlBucket();
        if (this$algoFlowControlBucket == null ? other$algoFlowControlBucket != null : !this$algoFlowControlBucket.equals(other$algoFlowControlBucket)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$dAppId = this.getdAppId();
        String other$dAppId = other.getdAppId();
        if (this$dAppId == null ? other$dAppId != null : !this$dAppId.equals(other$dAppId)) {
            return false;
        }
        String this$dTagId = this.getdTagId();
        String other$dTagId = other.getdTagId();
        if (this$dTagId == null ? other$dTagId != null : !this$dTagId.equals(other$dTagId)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        SeatBid this$seatBid = this.getSeatBid();
        SeatBid other$seatBid = other.getSeatBid();
        if (this$seatBid == null ? other$seatBid != null : !((Object)this$seatBid).equals(other$seatBid)) {
            return false;
        }
        Bid this$bid = this.getBid();
        Bid other$bid = other.getBid();
        return !(this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $configId = this.getConfigId();
        result = result * 59 + ($configId == null ? 43 : ((Object)$configId).hashCode());
        Long $dspId = this.getDspId();
        result = result * 59 + ($dspId == null ? 43 : ((Object)$dspId).hashCode());
        Integer $mt = this.getMt();
        result = result * 59 + ($mt == null ? 43 : ((Object)$mt).hashCode());
        Long $dispatcherId = this.getDispatcherId();
        result = result * 59 + ($dispatcherId == null ? 43 : ((Object)$dispatcherId).hashCode());
        Long $strategyId = this.getStrategyId();
        result = result * 59 + ($strategyId == null ? 43 : ((Object)$strategyId).hashCode());
        BidRequest $sspRequest = this.getSspRequest();
        result = result * 59 + ($sspRequest == null ? 43 : ((Object)$sspRequest).hashCode());
        BidRequest $adxRequest = this.getAdxRequest();
        result = result * 59 + ($adxRequest == null ? 43 : ((Object)$adxRequest).hashCode());
        BidResponse $adxResponse = this.getAdxResponse();
        result = result * 59 + ($adxResponse == null ? 43 : ((Object)$adxResponse).hashCode());
        BidResponse $dspResponse = this.getDspResponse();
        result = result * 59 + ($dspResponse == null ? 43 : ((Object)$dspResponse).hashCode());
        BigDecimal $sspRequestPrice = this.getSspRequestPrice();
        result = result * 59 + ($sspRequestPrice == null ? 43 : ((Object)$sspRequestPrice).hashCode());
        BigDecimal $adxRequestPrice = this.getAdxRequestPrice();
        result = result * 59 + ($adxRequestPrice == null ? 43 : ((Object)$adxRequestPrice).hashCode());
        BigDecimal $dspResponsePrice = this.getDspResponsePrice();
        result = result * 59 + ($dspResponsePrice == null ? 43 : ((Object)$dspResponsePrice).hashCode());
        BigDecimal $adxResponsePrice = this.getAdxResponsePrice();
        result = result * 59 + ($adxResponsePrice == null ? 43 : ((Object)$adxResponsePrice).hashCode());
        String $algoFlowControlBucket = this.getAlgoFlowControlBucket();
        result = result * 59 + ($algoFlowControlBucket == null ? 43 : $algoFlowControlBucket.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $dAppId = this.getdAppId();
        result = result * 59 + ($dAppId == null ? 43 : $dAppId.hashCode());
        String $dTagId = this.getdTagId();
        result = result * 59 + ($dTagId == null ? 43 : $dTagId.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        SeatBid $seatBid = this.getSeatBid();
        result = result * 59 + ($seatBid == null ? 43 : ((Object)$seatBid).hashCode());
        Bid $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        return result;
    }

    public String toString() {
        return "BuildAttribute(sspRequest=" + this.getSspRequest() + ", adxRequest=" + this.getAdxRequest() + ", adxResponse=" + this.getAdxResponse() + ", dspResponse=" + this.getDspResponse() + ", sspRequestPrice=" + this.getSspRequestPrice() + ", adxRequestPrice=" + this.getAdxRequestPrice() + ", dspResponsePrice=" + this.getDspResponsePrice() + ", adxResponsePrice=" + this.getAdxResponsePrice() + ", configId=" + this.getConfigId() + ", algoFlowControlBucket=" + this.getAlgoFlowControlBucket() + ", dspId=" + this.getDspId() + ", appId=" + this.getAppId() + ", tagId=" + this.getTagId() + ", dAppId=" + this.getdAppId() + ", dTagId=" + this.getdTagId() + ", mt=" + this.getMt() + ", mediaId=" + this.getMediaId() + ", dispatcherId=" + this.getDispatcherId() + ", strategyId=" + this.getStrategyId() + ", seatBid=" + this.getSeatBid() + ", bid=" + this.getBid() + ")";
    }
}

