/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.mapping;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.PositionMappingProperties;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.mapping.PositionMappingStrategy;
import com.bxm.adx.common.sell.position.mapping.Strategy;
import com.bxm.adx.common.sell.request.Impression;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PositionMappingStrategyFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(PositionMappingStrategyFactory.class);
    private final AdxProperties adxProperties;
    private final Map<Strategy, PositionMappingStrategy> strategyMap = Maps.newHashMap();

    public PositionMappingStrategyFactory(AdxProperties adxProperties) {
        this.adxProperties = adxProperties;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Collection strategies = event.getApplicationContext().getBeansOfType(PositionMappingStrategy.class).values();
        if (CollectionUtils.isEmpty(strategies)) {
            log.warn("position mapping strategy is empty");
            return;
        }
        for (PositionMappingStrategy strategy : strategies) {
            this.strategyMap.put(strategy.strategy(), strategy);
        }
    }

    public Position getPosition(BidRequest bidRequest, Impression impression) {
        PositionMappingProperties properties = this.getProperties(bidRequest, impression);
        Strategy strategy = Strategy.Default;
        if (Objects.nonNull(properties)) {
            strategy = Optional.ofNullable(properties.getStrategy()).orElse(Strategy.Default);
        }
        return this.strategyMap.get((Object)strategy).mapping(bidRequest, impression, properties);
    }

    private PositionMappingProperties getProperties(BidRequest bidRequest, Impression impression) {
        String mediaId = bidRequest.getMediaId();
        if (StringUtils.isEmpty((String)mediaId)) {
            return null;
        }
        List<PositionMappingProperties> properties = this.adxProperties.getPositionMapping();
        Optional<PositionMappingProperties> optional = this.findMediaConfig(properties, mediaId);
        return optional.orElse(null);
    }

    private Optional<PositionMappingProperties> findMediaConfig(List<PositionMappingProperties> list, String mediaId) {
        if (CollectionUtils.isEmpty(list)) {
            return Optional.empty();
        }
        return list.stream().filter(mediaConfig -> mediaId.equals(mediaConfig.getMediaId())).findFirst();
    }
}

