/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Image;
import com.bxm.adx.common.sell.response.Text;
import com.bxm.adx.common.sell.response.Video;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class Native
implements Serializable {
    private List<Asset> assets;
    private String template;

    public String findTitle() {
        return this.assets.stream().filter(x -> AdxConstants.AssetType.TITLE.getType().equals(x.getType()) && x.getText() != null).map(Asset::getText).map(Text::getText).findFirst().orElse(null);
    }

    public String findDesc() {
        return this.assets.stream().filter(x -> AdxConstants.AssetType.CONTENT.getType().equals(x.getType()) && x.getText() != null).map(Asset::getText).map(Text::getText).findFirst().orElse(null);
    }

    public Image findIcon() {
        return this.assets.stream().filter(x -> AdxConstants.AssetType.ICON.getType().equals(x.getType()) && x.getImg() != null).map(Asset::getImg).findFirst().orElse(null);
    }

    public Video findVideo() {
        return this.assets.stream().filter(x -> x.getVideo() != null).map(Asset::getVideo).findFirst().orElse(null);
    }

    public List<Image> findImage() {
        return this.assets.stream().filter(x -> AdxConstants.AssetType.LARGE_IMG.getType().equals(x.getType()) && x.getImg() != null).map(Asset::getImg).collect(Collectors.toList());
    }

    public static NativeBuilder builder() {
        return new NativeBuilder();
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public String getTemplate() {
        return this.template;
    }

    public Native setAssets(List<Asset> assets) {
        this.assets = assets;
        return this;
    }

    public Native setTemplate(String template) {
        this.template = template;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Native)) {
            return false;
        }
        Native other = (Native)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Asset> this$assets = this.getAssets();
        List<Asset> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !this$template.equals(other$template));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Native;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Asset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        return result;
    }

    public String toString() {
        return "Native(assets=" + this.getAssets() + ", template=" + this.getTemplate() + ")";
    }

    public Native() {
    }

    public Native(List<Asset> assets, String template) {
        this.assets = assets;
        this.template = template;
    }

    public static class NativeBuilder {
        private List<Asset> assets;
        private String template;

        NativeBuilder() {
        }

        public NativeBuilder assets(List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        public NativeBuilder template(String template) {
            this.template = template;
            return this;
        }

        public Native build() {
            return new Native(this.assets, this.template);
        }

        public String toString() {
            return "Native.NativeBuilder(assets=" + this.assets + ", template=" + this.template + ")";
        }
    }
}

