package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;

import javax.servlet.http.HttpServletResponse;

/**
 * 销售方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BidModelAdapter extends ModelAdapter {
    default AdxConstants.Media media() {
        return AdxConstants.Media.Unknown;
    }

    BidRequest convert(byte[] bytes);

    byte[] convert(BidResponse e, BidRequest bidRequest);

    default void customHttpResponse(byte[] data, HttpServletResponse response) {
        if (data == null || data.length == 0) {
            response.setStatus(204);
        }
    }

    /**
     * 后置处理 凤凰需要
     *
     * @param bidRequest
     * @param position
     */
    default BidRequest reBuildBidRequest(BidRequest bidRequest, Position position) {
        return bidRequest;
    }

    /**
     * 拒绝返回广告时客制化响应
     *
     * @param request
     * @param err
     * @return
     */
    default byte[] reject(BidRequest request, AdxErrEnum err) {
        return new byte[]{};
    }

    /**
     * 自定义程序异常的返回
     *
     * @param request
     * @param e
     * @return
     */
    default byte[] customExceptionResponse(BidRequest request, Exception e) {
        return null;
    }

    /**
     * 自定义没有广告返回
     *
     * @param request
     * @return
     */
    default byte[] customNullResponse(BidRequest request) {
        return null;
    }


    /**
     * 二段请求获取创意
     *
     * @param bytes
     * @return
     */
    default byte[] creative(byte[] bytes) {
        return new byte[]{};
    }

    /**
     * 二段请求自定义素材材响应
     *
     * @param data
     * @param response
     */
    default void customCreativeHttpResponse(byte[] data, HttpServletResponse response) {
        if (data == null || data.length == 0) {
            response.setStatus(204);
        }
    }

    /**
     * 转换request格式为可读
     *
     * @param request
     * @return
     */
    default String convertSspRequest(byte[] request) {
        return request == null ? null : new String(request);
    }

    /**
     * 转换response格式为可读
     *
     * @param response
     * @return
     */
    default String convertSspResponse(byte[] response) {
        return response == null ? null : new String(response);
    }

}
