package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherConfigCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@CachePush("DISPATCHERAB")
@Component
@Slf4j
public class DispatcherAB implements Pushable {
    private final Fetcher fetcher;
    private final Updater updater;
    private final com.bxm.warcar.xcache.Fetcher fetcher2;
    private final PositionService positionService;
    private final DspService dspService;
    private final DataSyncProducer dataSyncProducer;
    private final DispatcherConfigCached dispatcherConfigCached;

    public DispatcherAB(Fetcher fetcher, Updater updater, com.bxm.warcar.xcache.Fetcher fetcher2,
                        PositionService positionService, DspService dspService, DataSyncProducer dataSyncProducer, DispatcherConfigCached dispatcherConfigCached) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.fetcher2 = fetcher2;
        this.positionService = positionService;
        this.dspService = dspService;
        this.dataSyncProducer = dataSyncProducer;
        this.dispatcherConfigCached = dispatcherConfigCached;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        //参数验证
        if (Objects.isNull(o)) {
            if (log.isInfoEnabled()) {
                log.info("DISPATCHERAB push err: POSITION_ID is null");
            }
            return;
        }
        String positionId = Objects.toString(o);

        if (log.isInfoEnabled()) {
            log.info("DISPATCHERAB push {} : {}", positionId, new String(data));
        }
        DispatcherAbCacheVO dispatcherAbCacheVO = JsonHelper.convert(data, DispatcherAbCacheVO.class);
        if (dispatcherAbCacheVO == null) {
            return;
        }

        String key = dispatcherAbCacheVO.getClass().getName() + "$" + dispatcherAbCacheVO.getPositionId();
        dataSyncProducer.post(key, dispatcherAbCacheVO);

        //移除广告位下用户重排序
        // FIXME: 2023/2/8 这个key有数据过大风险，造成redis异常
        updater.remove(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId));
    }
}
