package com.bxm.adx.common.buy.position;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/7/15
 **/
@Service
@Slf4j
public class AdvertPointServiceImpl implements AdvertPointService{
    private final AdvertPointCached advertPointCached;
    private final DspService dspService;

    public AdvertPointServiceImpl(AdvertPointCached advertPointCached, DspService dspService) {
        this.advertPointCached = advertPointCached;
        this.dspService = dspService;
    }

    @Override
    public AdvertPoint getAdvertPointByDspId(String dspId, String dspAppId, String dspPositionId) {
        Dsp dsp = dspService.get(Long.valueOf(dspId));
        if (dsp.getDspCode().contains("pangu")) {
            return null;
        }
        AdvertPoint advertPoint = advertPointCached.getAdPoint(dspId, dspAppId, dspPositionId);
        return advertPoint;
    }
}
