package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigCaching;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Configuration
@Slf4j
public class DispatcherABConfigDataSyncHandler implements DataSyncHandler {
    private final DispatcherABConfigCaching dispatcherABConfigCaching;

    public DispatcherABConfigDataSyncHandler(DispatcherABConfigCaching dispatcherABConfigCaching) {
        this.dispatcherABConfigCaching = dispatcherABConfigCaching;
    }

    @Override
    public Class<?> getClazz() {
        return DispatcherAbCacheVO.class;
    }

    @Override
    public Object set(String key, Object object) {
        if (!(object instanceof DispatcherAbCacheVO)) {
            log.warn("object {} not support", object);
            return object;
        }

        DispatcherAbCacheVO dispatcherAbCacheVO = (DispatcherAbCacheVO) object;

        if (log.isDebugEnabled()) {
            log.debug("dispatcher cache = {}", JsonHelper.convert(dispatcherAbCacheVO));
        }

        DispatcherABConfig dispatcherABConfig = JsonHelper.convert(JsonHelper.convert(dispatcherAbCacheVO), DispatcherABConfig.class);
        dispatcherABConfigCaching.set(dispatcherABConfig.getId(), dispatcherABConfig);
        return object;
    }
}
