package com.bxm.adx.common.filter;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.market.MarketRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>DSP抽象过滤器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 16:32
 */

@Slf4j
public abstract class AbstractDspFilter implements Filter {

    public AbstractDspFilter() {
    }

    @Override
    public void filter(FilterRequest request) {

        MarketOrders marketOrders = request.getMarketOrders();
        if (marketOrders == null) {
            log.debug(" marketOrders is null . ");
            return;
        }

        final List<Dispatcher> dsps = doFilter(marketOrders);
        removeDsp(dsps, marketOrders);
    }

    /**
     * DSP相关过滤实现
     *
     * @param marketOrders
     * @return
     */
    protected abstract List<Dispatcher> doFilter(MarketOrders marketOrders);

    /**
     * 移除被过滤掉的DSP
     *
     * @param dispatcherList
     * @param marketOrders
     */
    protected void removeDsp(List<Dispatcher> dispatcherList, MarketOrders marketOrders) {
        if (CollectionUtils.isEmpty(dispatcherList)) {
            return;
        }
        List<MarketRequest> requests = marketOrders.getRequests();
        if (CollectionUtils.isEmpty(requests)) {
            return;
        }
        final Iterator<MarketRequest> iterator = requests.iterator();
        dispatcherList.forEach(dispatcher -> {
            while (iterator.hasNext()) {
                final MarketRequest next = iterator.next();
                Iterator<BuyerWrapper> buyerWrapperIterator = next.getBuyers().iterator();
                while (buyerWrapperIterator.hasNext()) {
                    BuyerWrapper buyerWrapper = buyerWrapperIterator.next();
                    Dispatcher currentDispatcher = buyerWrapper.getDispatcher();
                    if (dispatcher.getConfigId().equals(currentDispatcher.getConfigId())
                            && dispatcher.getDspId().equals(currentDispatcher.getDspId()) ) {
                        log.debug("remove dspConfigId = {}, dspId = {}", dispatcher.getConfigId(), dispatcher.getDspId());
                        buyerWrapperIterator.remove();

                        //如果buyers为空，则需要把上层也移除
                        if (next.getBuyers().size() == 0) {
                            iterator.remove();
                        }
                    }
                }
            }

        });
    }
}
