package com.bxm.adx.common.market.exchange.rebuild.offer;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.mccms.facade.enums.OfferSettle;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author fgf
 * @date 2023/1/10
 **/
@Configuration
public class DspAvgPriceOffer implements Offer {
    @Override
    public Map<Bid, OfferResult> offer(Collection<Bid> bids, BidRequest request, Dispatcher dispatcher) {
        Map<Bid, OfferResult> offerResultMap = new HashMap<>(bids.size());

        String mediaSettle = dispatcher.getMediaSettle();
        int chargeType = AdxConstants.ChargeType.CPM;
        if (Objects.nonNull(mediaSettle)) {
            if (OfferSettle.CPC.name().equalsIgnoreCase(mediaSettle)) {
                chargeType = AdxConstants.ChargeType.CPC;
            }
        }

        for (Bid bid : bids) {
            offerResultMap.put(bid, OfferResult.builder()
                            .chargeType(chargeType)
                            .offer(dispatcher.getDspAvgPrice().movePointRight(2))
                    .build());
        }
        return offerResultMap;
    }

    @Override
    public OfferType offerType() {
        return OfferType.Dsp_Avg_Price;
    }
}
