package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.sell.BidResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class AdxBidResponseBuildFactory implements ApplicationListener<ApplicationReadyEvent> {
    private List<AdxBidResponseBuilder> builderList = new ArrayList<>();
    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        builderList.addAll(event.getApplicationContext().getBeansOfType(AdxBidResponseBuilder.class).values());
        builderList.sort(Comparator.comparingInt(Ordered::getOrder));
    }

    public BidResponse buildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        builderList.forEach(builder -> builder.rebuildAdxBidResponse(bidResponse, attribute));
        return bidResponse;
    }

    private BidResponse initAdxBidResponse(BidResponse bidResponse) {
        BidResponse adxBidResponse = new BidResponse();
        BeanUtils.copyProperties(bidResponse, adxBidResponse);
        return adxBidResponse;
    }
}
