package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class BidResponseBuilder implements AdxBidResponseBuilder {

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        BidRequest bidRequest = attribute.getBidRequest();
        if (StringUtils.isEmpty(bidResponse.getId())) {
            bidResponse.setId(bidRequest.getId());
        }
    }
}
