package com.bxm.adx.common.sell.init;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author fgf
 * @date 2022/8/26
 **/
@Configuration
public class RequestInitializer implements BidRequestInitializer {
    @Override
    public void accept(BidRequest bidRequest, InitializerParam param) {
        //id
        if (StringUtils.isEmpty(bidRequest.getId())) {
            bidRequest.setId(RandomStringUtils.randomAlphabetic(10));
        }
        //at
        if (Objects.isNull(bidRequest.getAt())) {
            bidRequest.setAt(AdxConstants.At.FIRST);
        }
        if (Objects.isNull(bidRequest.getTest())) {
            bidRequest.setTest((int) AdxConstants.NO);
        }
        if (Objects.isNull(bidRequest.getT_max())) {
            bidRequest.setT_max(100);
        }
        if (Objects.isNull(bidRequest.getVer())) {
            bidRequest.setVer("2.4");
        }
        Position position = param.getPosition();
        //cooperationType 合作类型
        bidRequest.setCooperationType(position.getCooperationType());
        //bxmTagId
        bidRequest.setBxmTagId(position.getPositionId());
        //bidModel 默认支持CPM
        if (Objects.isNull(bidRequest.getBid_model())) {
            bidRequest.setBid_model(AdxConstants.BidModel.SUPPORT_CPM);
        }
        initBidRequestByDockingMethodType(bidRequest, position);
    }

    /**
     * 根据对接类型填充请求等待时间&超时时间
     * @param bidRequest
     * @param position
     */
    private void initBidRequestByDockingMethodType(BidRequest bidRequest, Position position) {
        Integer dockingMethodType = position.getDockingMethodType();
        bidRequest.setDockingMethodType(dockingMethodType);

        Long waitTime = position.getWaitTime();
        Long overTime = position.getOvertime();
        if (Objects.nonNull(dockingMethodType)) {
            if (Objects.isNull(waitTime)) {
                if (AdxConstants.DockingMethodType.API == dockingMethodType) {
                    waitTime = AdxConstants.API_WAIT_TIME;
                } else {
                    waitTime = AdxConstants.SDK_WAIT_TIME;
                }
            }
            if (Objects.isNull(overTime)) {
                if (AdxConstants.DockingMethodType.API == dockingMethodType) {
                    overTime = AdxConstants.API_OVER_TIME;
                } else {
                    overTime = AdxConstants.SDK_OVER_TIME;
                }
            }
        } else {
            waitTime = 0L;
            overTime = 0L;
        }
        bidRequest.setWaitTime(waitTime);
        bidRequest.setOvertime(overTime);
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
