package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.CacheKeys;
import com.bxm.warcar.cache.Fetcher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by Arei on 2020/12/14.
 */
@Component
@Slf4j
public class InnerPackageNameVerify extends AbstractVerify {
    private final static List<String> PACKAGENAME = Arrays.asList(
            "com.wquant.bottle",
            "cn.zsbro.bigwhale",
            "com.bxm.sdk.lll",
            "com.bxm.sdkdemo",
            "com.wuba",
            "com.bxm.localmastercard",
            "cn.com.xinwei.zhongye",
            "com.cashcat.sdkdemo"
    );
    private final Fetcher fetcher;

    public InnerPackageNameVerify(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }

        String packageName = context.getPackageName();
        if (StringUtils.isEmpty(packageName)) {
            if (log.isDebugEnabled()) {
                log.debug("packageName is null");
            }
            return;
        }

        //如果是内部包名，跳过验证
        List<String> pns = fetcher.fetchList(CacheKeys.getPackageNameKey(), String.class);
        if (CollectionUtils.isEmpty(pns)) {
            if (PACKAGENAME.contains(packageName)) {
                context.setResult(true);
                return;
            }
        } else {
            if (pns.contains(packageName)) {
                context.setResult(true);
                return;
            }
        }
    }
}
