package com.bxm.adx.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.concurrent.TimeUnit;

/**
 * @author fgf
 * @date 2023/5/5
 **/
@Data
@ConfigurationProperties(prefix = "adx.dispatcher-flow")
public class DispatcherFlowProperties {
    public static final String YES = "1";
    public static final int CEILING = 90;
    public static final int FLOOR = 0;
    /**
     * redis db
     */
    private Integer db = 6;
    /**
     * redis-key-expire
     */
    private Integer expire = 24 * 3600;
    /**
     * 一次游标获取的key个数
     */
    private Integer pipelineCount = 50;
    /**
     * redis incr/decr 步长
     */
    private Long cr = 10L;
    /**
     * redis-key本地缓存时长
     */
    private Integer cacheTime = 10;
    /**
     * redis-key本地缓存时长单位
     */
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    /**
     * 是否跳过本地缓存
     */
    private Boolean skipNativeCache = false;
}
