package com.bxm.adx.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/**
 * Created by Arei on 2020/10/9.
 */
@ControllerAdvice
@Slf4j
public class ExceptionAdvice {

    private final ObjectMapper objectMapper;

    public ExceptionAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(Exception.class)
    public ResponseEntity<Object> handleException(Exception ex) {
        if (log.isErrorEnabled()) {
            log.debug("catch error = ", ex);
        }

        return ResponseEntity.ok().build();
    }
}
