package com.bxm.adx.common.adapter;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;

/**
 * @author zhangdong
 * @date 2022/10/17
 */
@Slf4j
public abstract class AbstractDealExceptionBuyModelAdapter implements BuyModelAdapter, PluginConfigAware {

    private PluginConfig pluginConfig;

    @Override
    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public PluginConfig getPluginConfig() {
        return pluginConfig;
    }

    @Override
    public byte[] buildRequest(BidRequest request) {
        try {
            log.debug(pluginConfig.getKey() + " bxmRequest:{}", JsonHelper.convert(request));
            byte[] bytes = dealRequest(request);
            log.debug(pluginConfig.getKey() + " request:{}", new String(bytes));
            return bytes;
        } catch (Exception e) {
            log.debug(getPluginConfig().getKey() + " buildRequest error - bxmRequest:{},ex:", JsonHelper.convert(request), e);
            return dealRequestException(request, e);
        }
    }

    @Override
    public BidResponse buildResponse(byte[] response) {
        try {
            log.debug(pluginConfig.getKey() + " response:{}", new String(response));
            BidResponse bidResponse = dealResponse(response);
            log.debug(pluginConfig.getKey() + " bxmResponse:{}", JsonHelper.convert(bidResponse));
            return bidResponse;
        } catch (Exception e) {
            log.debug(getPluginConfig().getKey() + " buildResponse error - response:{},ex:", new String(response), e);
            return dealResponseException(response, e);
        }
    }

    public abstract byte[] dealRequest(BidRequest bidRequest);

    public byte[] dealRequestException(BidRequest bidRequest, Exception e) {
        return null;
    }

    public abstract BidResponse dealResponse(byte[] response);

    public BidResponse dealResponseException(byte[] response, Exception e) {
        return null;
    }

}
